/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, MediumTests.class})
public class TestRowIndexV1DataEncoder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRowIndexV1DataEncoder.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private FileSystem fs;
    private DataBlockEncoding dataBlockEncoding;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.fs = FileSystem.get((Configuration)this.conf);
        this.dataBlockEncoding = DataBlockEncoding.ROW_INDEX_V1;
    }

    @Test
    public void testBlockCountWritten() throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "testHFileFormatV3");
        int entryCount = 10000;
        this.writeDataToHFile(hfilePath, 10000);
    }

    private void writeDataToHFile(Path hfilePath, int entryCount) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(1024).withDataBlockEncoding(this.dataBlockEncoding).withCellComparator((CellComparator)CellComparatorImpl.COMPARATOR).build();
        CacheConfig cacheConfig = new CacheConfig(this.conf);
        HFile.Writer writer = new HFile.WriterFactory(this.conf, cacheConfig).withPath(this.fs, hfilePath).withFileContext(context).create();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(entryCount);
        this.writeKeyValues(entryCount, writer, keyValues);
        FSDataInputStream fsdis = this.fs.open(hfilePath);
        long fileSize = this.fs.getFileStatus(hfilePath).getLen();
        FixedFileTrailer trailer = FixedFileTrailer.readFromStream((FSDataInputStream)fsdis, (long)fileSize);
        Assert.assertEquals((long)278L, (long)trailer.getDataIndexCount());
    }

    private void writeKeyValues(int entryCount, HFile.Writer writer, List<KeyValue> keyValues) throws IOException {
        for (int i = 0; i < entryCount; ++i) {
            byte[] keyBytes = this.intToBytes(i);
            byte[] valueBytes = new byte[]{};
            KeyValue keyValue = new KeyValue(keyBytes, null, null, valueBytes);
            writer.append((Cell)keyValue);
            keyValues.add(keyValue);
        }
        writer.close();
    }

    private byte[] intToBytes(int i) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(i);
        return bb.array();
    }
}

