/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RSSnapshotVerifier;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRSSnapshotVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(TestRSSnapshotVerifier.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSSnapshotVerifier.class);
    private HBaseTestingUtility TEST_UTIL;
    private final TableName tableName = TableName.valueOf((String)"TestRSSnapshotVerifier");
    private final byte[] cf = Bytes.toBytes((String)"cf");
    private final SnapshotDescription snapshot = new SnapshotDescription("test-snapshot", this.tableName, SnapshotType.FLUSH);
    private SnapshotProtos.SnapshotDescription snapshotProto = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)this.snapshot);

    @Before
    public void setup() throws Exception {
        this.TEST_UTIL = new HBaseTestingUtility();
        this.TEST_UTIL.startMiniCluster(3);
        byte[][] splitKeys = new RegionSplitter.HexStringSplit().split(10);
        Table table = this.TEST_UTIL.createTable(this.tableName, this.cf, splitKeys);
        this.TEST_UTIL.loadTable(table, this.cf, false);
        this.TEST_UTIL.getAdmin().flush(this.tableName);
        Configuration conf = this.TEST_UTIL.getConfiguration();
        this.snapshotProto = SnapshotDescriptionUtils.validate((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Configuration)conf);
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Path)rootDir, (Configuration)conf);
        FileSystem workingDirFs = workingDir.getFileSystem(conf);
        if (!workingDirFs.exists(workingDir)) {
            workingDirFs.mkdirs(workingDir);
        }
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(this.snapshot.getName());
        SnapshotManifest manifest = SnapshotManifest.create((Configuration)conf, (FileSystem)workingDirFs, (Path)workingDir, (SnapshotProtos.SnapshotDescription)this.snapshotProto, (ForeignExceptionSnare)monitor);
        manifest.addTableDescriptor(this.TEST_UTIL.getHBaseCluster().getMaster().getTableDescriptors().get(this.tableName));
        SnapshotDescriptionUtils.writeSnapshotInfo((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Path)workingDir, (FileSystem)workingDirFs);
        this.TEST_UTIL.getHBaseCluster().getRegions(this.tableName).forEach(r -> {
            try {
                r.addRegionToSnapshot(this.snapshotProto, (ForeignExceptionSnare)monitor);
            }
            catch (IOException e) {
                LOG.warn("Failed snapshot region {}", (Object)r.getRegionInfo());
            }
        });
        manifest.consolidate();
    }

    @Test(expected=CorruptedSnapshotException.class)
    public void testVerifyStoreFile() throws Exception {
        RSSnapshotVerifier verifier = this.TEST_UTIL.getHBaseCluster().getRegionServer(0).getRsSnapshotVerifier();
        HRegion region = this.TEST_UTIL.getHBaseCluster().getRegions(this.tableName).stream().filter(r -> !r.getStore(this.cf).getStorefiles().isEmpty()).findFirst().get();
        Path filePath = ((HStoreFile)new ArrayList(region.getStore(this.cf).getStorefiles()).get(0)).getPath();
        this.TEST_UTIL.getDFSCluster().getFileSystem().delete(filePath, true);
        LOG.info("delete store file {}", (Object)filePath);
        verifier.verifyRegion(this.snapshotProto, region.getRegionInfo());
    }

    @After
    public void teardown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }
}

