/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.prometheus;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MetricsExportHelper;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PrometheusHadoopServlet
extends HttpServlet {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<=[a-z])(?=[A-Z])|(?<=[A-Z])(?=([A-Z][a-z]))|\\W|(_)+");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.writeMetrics(resp.getWriter(), "true".equals(req.getParameter("description")), req.getParameter("qry"));
    }

    static String toPrometheusName(String metricRecordName, String metricName) {
        String baseName = metricRecordName + StringUtils.capitalize(metricName);
        CharSequence[] parts = SPLIT_PATTERN.split(baseName);
        return String.join((CharSequence)"_", parts).toLowerCase();
    }

    @RestrictedApi(explanation="Should only be called in tests or self", link="", allowedOnPath=".*/src/test/.*|.*/PrometheusHadoopServlet\\.java")
    void writeMetrics(Writer writer, boolean descriptionEnabled, String queryParam) throws IOException {
        Collection<MetricsRecord> metricRecords = MetricsExportHelper.export();
        for (MetricsRecord metricsRecord : metricRecords) {
            for (AbstractMetric metrics : metricsRecord.metrics()) {
                String description;
                if (metrics.type() != MetricType.COUNTER && metrics.type() != MetricType.GAUGE) continue;
                String key = PrometheusHadoopServlet.toPrometheusName(metricsRecord.name(), metrics.name());
                if (queryParam != null && !key.contains(queryParam)) continue;
                if (descriptionEnabled && !(description = metrics.description()).isEmpty()) {
                    writer.append("# HELP ").append(description).append('\n');
                }
                writer.append("# TYPE ").append(key).append(" ").append(metrics.type().toString().toLowerCase()).append('\n').append(key).append("{");
                String sep = "";
                for (MetricsTag tag : metricsRecord.tags()) {
                    String tagName = tag.name().toLowerCase();
                    writer.append(sep).append(tagName).append("=\"").append(tag.value()).append("\"");
                    sep = ",";
                }
                writer.append("} ");
                writer.append(metrics.value().toString()).append('\n');
            }
        }
        writer.flush();
    }
}

