/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.io.MetricsIOSource;
import org.apache.hadoop.hbase.io.MetricsIOWrapper;
import org.apache.hadoop.hbase.io.MetricsIOWrapperImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsIO {
    private static volatile MetricsIO instance;
    private final MetricsIOSource source;
    private final MetricsIOWrapper wrapper;

    @RestrictedApi(explanation="Should only be called in TestMetricsIO", link="", allowedOnPath=".*/(MetricsIO|TestMetricsIO).java")
    MetricsIO(MetricsIOWrapper wrapper) {
        this(CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createIO(wrapper), wrapper);
    }

    MetricsIO(MetricsIOSource source, MetricsIOWrapper wrapper) {
        this.source = source;
        this.wrapper = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetricsIO getInstance() {
        if (instance != null) return instance;
        Class<MetricsIO> clazz = MetricsIO.class;
        synchronized (MetricsIO.class) {
            if (instance != null) return instance;
            instance = new MetricsIO(new MetricsIOWrapperImpl());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public MetricsIOSource getMetricsSource() {
        return this.source;
    }

    public MetricsIOWrapper getWrapper() {
        return this.wrapper;
    }

    public void updateFsReadTime(long t) {
        this.source.updateFsReadTime(t);
    }

    public void updateFsPreadTime(long t) {
        this.source.updateFsPReadTime(t);
    }

    public void updateFsWriteTime(long t) {
        this.source.updateFsWriteTime(t);
    }

    public void incrSlowFsRead() {
        this.source.incrSlowFsRead();
    }
}

