/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.util.Objects;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreLoader;

abstract class FileKeyStoreLoader
implements KeyStoreLoader {
    final String keyStorePath;
    final String trustStorePath;
    final char[] keyStorePassword;
    final char[] trustStorePassword;

    FileKeyStoreLoader(String keyStorePath, String trustStorePath, char[] keyStorePassword, char[] trustStorePassword) {
        this.keyStorePath = keyStorePath;
        this.trustStorePath = trustStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePassword = trustStorePassword;
    }

    static abstract class Builder<T extends FileKeyStoreLoader> {
        String keyStorePath;
        String trustStorePath;
        char[] keyStorePassword;
        char[] trustStorePassword;

        Builder() {
        }

        Builder<T> setKeyStorePath(String keyStorePath) {
            this.keyStorePath = Objects.requireNonNull(keyStorePath);
            return this;
        }

        Builder<T> setTrustStorePath(String trustStorePath) {
            this.trustStorePath = Objects.requireNonNull(trustStorePath);
            return this;
        }

        Builder<T> setKeyStorePassword(char[] keyStorePassword) {
            this.keyStorePassword = Objects.requireNonNull(keyStorePassword);
            return this;
        }

        Builder<T> setTrustStorePassword(char[] trustStorePassword) {
            this.trustStorePassword = Objects.requireNonNull(trustStorePassword);
            return this;
        }

        abstract T build();
    }
}

