/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateImpl;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSource;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsUserAggregateFactory {
    public static final String METRIC_USER_ENABLED_CONF = "hbase.regionserver.user.metrics.enabled";
    public static final boolean DEFAULT_METRIC_USER_ENABLED_CONF = false;

    private MetricsUserAggregateFactory() {
    }

    public static MetricsUserAggregate getMetricsUserAggregate(Configuration conf) {
        if (conf.getBoolean(METRIC_USER_ENABLED_CONF, false)) {
            return new MetricsUserAggregateImpl(conf);
        }
        return new MetricsUserAggregate(){

            @Override
            public MetricsUserAggregateSource getSource() {
                return null;
            }

            @Override
            public void updatePut(long t) {
            }

            @Override
            public void updateDelete(long t) {
            }

            @Override
            public void updateGet(long time, long blockBytesScanned) {
            }

            @Override
            public void updateIncrement(long time, long blockBytesScanned) {
            }

            @Override
            public void updateAppend(long time, long blockBytesScanned) {
            }

            @Override
            public void updateReplay(long t) {
            }

            @Override
            public void updateScan(long time, long blockBytesScanned) {
            }

            @Override
            public void updateCheckAndMutate(long blockBytesScanned) {
            }

            @Override
            public void updateFilteredReadRequests() {
            }

            @Override
            public void updateReadRequestCount() {
            }
        };
    }
}

