/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ProcedureStoreBase
implements ProcedureStore {
    private final CopyOnWriteArrayList<ProcedureStore.ProcedureStoreListener> listeners = new CopyOnWriteArrayList();
    private final AtomicBoolean running = new AtomicBoolean(false);

    protected boolean setRunning(boolean isRunning) {
        return this.running.getAndSet(isRunning) != isRunning;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void registerListener(ProcedureStore.ProcedureStoreListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean unregisterListener(ProcedureStore.ProcedureStoreListener listener) {
        return this.listeners.remove(listener);
    }

    protected final void sendPostSyncSignal() {
        this.listeners.forEach(ProcedureStore.ProcedureStoreListener::postSync);
    }

    protected final void sendAbortProcessSignal() {
        this.listeners.forEach(ProcedureStore.ProcedureStoreListener::abortProcess);
    }

    protected final void sendForceUpdateSignal(long[] procIds) {
        this.listeners.forEach(l -> l.forceUpdate(procIds));
    }
}

