/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.MetaWithReplicasTestBase;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestShutdownOfMetaReplicaHolder
extends MetaWithReplicasTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestShutdownOfMetaReplicaHolder.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestShutdownOfMetaReplicaHolder.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestShutdownOfMetaReplicaHolder.startCluster();
    }

    @Test
    public void testShutdownOfReplicaHolder() throws Exception {
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             RegionLocator locator = conn.getRegionLocator(TableName.META_TABLE_NAME);){
            HRegionLocation hrl = (HRegionLocation)locator.getRegionLocations(HConstants.EMPTY_START_ROW, true).get(1);
            ServerName oldServer = hrl.getServerName();
            TEST_UTIL.getHBaseClusterInterface().killRegionServer(oldServer);
            LOG.debug("Waiting for the replica {} to come up", (Object)hrl.getRegion());
            TEST_UTIL.waitFor(30000L, () -> {
                HRegionLocation loc = (HRegionLocation)locator.getRegionLocations(HConstants.EMPTY_START_ROW, true).get(1);
                return loc != null && !loc.getServerName().equals((Object)oldServer);
            });
            LOG.debug("Replica {} is online on {}, old server is {}", new Object[]{hrl.getRegion(), ((HRegionLocation)locator.getRegionLocations(HConstants.EMPTY_START_ROW, true).get(1)).getServerName(), oldServer});
        }
    }
}

