/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class CellCounter
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger((String)CellCounter.class.getName());
    static final String NAME = "CellCounter";
    private static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Path outputDir = new Path(args[1]);
        String reportSeparatorString = args.length > 2 ? args[2] : ":";
        conf.set("ReportSeparator", reportSeparatorString);
        Job job = Job.getInstance((Configuration)conf, (String)conf.get(JOB_NAME_CONF_KEY, "CellCounter_" + tableName));
        job.setJarByClass(CellCounter.class);
        Scan scan = CellCounter.getConfiguredScanForJob(conf, args);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, CellCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        job.setReducerClass(LongSumReducer.class);
        job.setCombinerClass(LongSumReducer.class);
        return job;
    }

    private static Scan getConfiguredScanForJob(Configuration conf, String[] args) throws IOException {
        long[] timeRange;
        Scan s = TableInputFormat.createScanFromConfiguration(conf);
        if (conf.get("hbase.mapreduce.scan.maxversions") == null) {
            s.setMaxVersions(Integer.MAX_VALUE);
        }
        s.setCacheBlocks(false);
        Filter rowFilter = CellCounter.getRowFilter(args);
        if (rowFilter != null) {
            LOG.info("Setting Row Filter for counter.");
            s.setFilter(rowFilter);
        }
        if ((timeRange = CellCounter.getTimeRange(args)) != null) {
            LOG.info("Setting TimeRange for counter.");
            s.setTimeRange(timeRange[0], timeRange[1]);
        }
        return s;
    }

    private static Filter getRowFilter(String[] args) {
        String filterCriteria;
        PrefixFilter rowFilter = null;
        String string = filterCriteria = args.length > 3 ? args[3] : null;
        if (filterCriteria == null) {
            return null;
        }
        if (filterCriteria.startsWith("^")) {
            String regexPattern = filterCriteria.substring(1, filterCriteria.length());
            rowFilter = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator(regexPattern));
        } else {
            rowFilter = new PrefixFilter(Bytes.toBytesBinary((String)filterCriteria));
        }
        return rowFilter;
    }

    private static long[] getTimeRange(String[] args) throws IOException {
        String startTimeArgKey = "--starttime=";
        String endTimeArgKey = "--endtime=";
        long startTime = 0L;
        long endTime = 0L;
        for (int i = 1; i < args.length; ++i) {
            System.out.println("i:" + i + "arg[i]" + args[i]);
            if (args[i].startsWith("--starttime=")) {
                startTime = Long.parseLong(args[i].substring("--starttime=".length()));
            }
            if (!args[i].startsWith("--endtime=")) continue;
            endTime = Long.parseLong(args[i].substring("--endtime=".length()));
        }
        if (startTime == 0L && endTime == 0L) {
            return null;
        }
        endTime = endTime == 0L ? Long.MAX_VALUE : endTime;
        return new long[]{startTime, endTime};
    }

    public int run(String[] args) throws Exception {
        if (args.length < 2) {
            this.printUsage(args.length);
            return -1;
        }
        Job job = CellCounter.createSubmittableJob(this.getConf(), args);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    private void printUsage(int parameterCount) {
        System.err.println("ERROR: Wrong number of parameters: " + parameterCount);
        System.err.println("Usage: hbase cellcounter <tablename> <outputDir> [reportSeparator] [^[regex pattern] or [Prefix]] [--starttime=<starttime> --endtime=<endtime>]");
        System.err.println("  Note: -D properties will be applied to the conf used.");
        System.err.println("  Additionally, all of the SCAN properties from TableInputFormat can be specified to get fine grained control on what is counted.");
        System.err.println("   -Dhbase.mapreduce.scan.row.start=<rowkey>");
        System.err.println("   -Dhbase.mapreduce.scan.row.stop=<rowkey>");
        System.err.println("   -Dhbase.mapreduce.scan.columns=\"<col1> <col2>...\"");
        System.err.println("   -Dhbase.mapreduce.scan.column.family=<family1>,<family2>, ...");
        System.err.println("   -Dhbase.mapreduce.scan.timestamp=<timestamp>");
        System.err.println("   -Dhbase.mapreduce.scan.timerange.start=<timestamp>");
        System.err.println("   -Dhbase.mapreduce.scan.timerange.end=<timestamp>");
        System.err.println("   -Dhbase.mapreduce.scan.maxversions=<count>");
        System.err.println("   -Dhbase.mapreduce.scan.cachedrows=<count>");
        System.err.println("   -Dhbase.mapreduce.scan.batchsize=<count>");
        System.err.println(" <reportSeparator> parameter can be used to override the default report separator string : used to separate the rowId/column family name and qualifier name.");
        System.err.println(" [^[regex pattern] or [Prefix] parameter can be used to limit the cell counter count operation to a limited subset of rows from the table based on regex or prefix pattern.");
    }

    public static void main(String[] args) throws Exception {
        int errCode = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new CellCounter(), (String[])args);
        System.exit(errCode);
    }

    static class LongSumReducer<Key>
    extends Reducer<Key, LongWritable, Key, LongWritable> {
        private LongWritable result = new LongWritable();

        LongSumReducer() {
        }

        public void reduce(Key key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long sum = 0L;
            for (LongWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write(key, (Object)this.result);
        }
    }

    static class CellCounterMapper
    extends TableMapper<Text, LongWritable> {
        private Configuration conf;
        private String separator;
        private byte[] lastRow;
        private String currentRowKey;
        byte[] currentFamily = null;
        String currentFamilyName = null;
        byte[] currentQualifier = null;
        String currentQualifierName = null;
        String currentRowQualifierName = null;

        CellCounterMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.conf = context.getConfiguration();
            this.separator = this.conf.get("ReportSeparator", ":");
        }

        @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="Findbugs is blind to the Precondition null check")
        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            Preconditions.checkState((values != null ? 1 : 0) != 0, (Object)"values passed to the map is null");
            try {
                byte[] currentRow = values.getRow();
                if (this.lastRow == null || !Bytes.equals((byte[])this.lastRow, (byte[])currentRow)) {
                    this.lastRow = currentRow;
                    this.currentRowKey = Bytes.toStringBinary((byte[])currentRow);
                    this.currentFamily = null;
                    this.currentQualifier = null;
                    context.getCounter((Enum)Counters.ROWS).increment(1L);
                    context.write((Object)new Text("Total ROWS"), (Object)new LongWritable(1L));
                }
                if (!values.isEmpty()) {
                    int cellCount = 0;
                    for (Cell value : values.listCells()) {
                        ++cellCount;
                        long size = value.getSerializedSize();
                        if (this.currentFamily == null || !CellUtil.matchingFamily((Cell)value, (byte[])this.currentFamily)) {
                            this.currentFamily = CellUtil.cloneFamily((Cell)value);
                            this.currentFamilyName = Bytes.toStringBinary((byte[])this.currentFamily);
                            this.currentQualifier = null;
                            context.getCounter("CF", this.currentFamilyName).increment(1L);
                            if (1L == context.getCounter("CF", this.currentFamilyName).getValue()) {
                                context.write((Object)new Text("Total Families Across all Rows"), (Object)new LongWritable(1L));
                                context.write((Object)new Text(this.currentFamily), (Object)new LongWritable(1L));
                            }
                            context.getCounter((Enum)Counters.SIZE).increment(size);
                            context.write((Object)new Text("Total SIZE"), (Object)new LongWritable(size));
                            context.getCounter("CF", this.currentFamilyName + "_Size").increment(size);
                            context.write((Object)new Text(this.currentFamilyName + "_Size"), (Object)new LongWritable(size));
                        }
                        if (this.currentQualifier == null || !CellUtil.matchingQualifier((Cell)value, (byte[])this.currentQualifier)) {
                            this.currentQualifier = CellUtil.cloneQualifier((Cell)value);
                            this.currentQualifierName = this.currentFamilyName + this.separator + Bytes.toStringBinary((byte[])this.currentQualifier);
                            this.currentRowQualifierName = this.currentRowKey + this.separator + this.currentQualifierName;
                            context.write((Object)new Text("Total Qualifiers across all Rows"), (Object)new LongWritable(1L));
                            context.write((Object)new Text(this.currentQualifierName), (Object)new LongWritable(1L));
                            context.getCounter("Q", this.currentQualifierName + "_Size").increment(size);
                            context.write((Object)new Text(this.currentQualifierName + "_Size"), (Object)new LongWritable(size));
                        }
                        context.write((Object)new Text(this.currentRowQualifierName + "_Versions"), (Object)new LongWritable(1L));
                    }
                    context.getCounter((Enum)Counters.CELLS).increment((long)cellCount);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public static enum Counters {
            ROWS,
            CELLS,
            SIZE;

        }
    }
}

