/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.migrate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.regionserver.storefiletracker.InitializeStoreFileTrackerProcedure;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RollingUpgradeChore
extends ScheduledChore {
    static final String ROLLING_UPGRADE_CHORE_PERIOD_SECONDS_KEY = "hbase.master.rolling.upgrade.chore.period.secs";
    static final int DFAULT_ROLLING_UPGRADE_CHORE_PERIOD_SECONDS = 10;
    static final String ROLLING_UPGRADE_CHORE_DELAY_SECONDS_KEY = "hbase.master.rolling.upgrade.chore.delay.secs";
    static final long DEFAULT_ROLLING_UPGRADE_CHORE_DELAY_SECONDS = 30L;
    static final int CONCURRENT_PROCEDURES_COUNT = 5;
    private static final Logger LOG = LoggerFactory.getLogger(RollingUpgradeChore.class);
    ProcedureExecutor<MasterProcedureEnv> procedureExecutor;
    private TableDescriptors tableDescriptors;
    private List<InitializeStoreFileTrackerProcedure> processingProcs = new ArrayList<InitializeStoreFileTrackerProcedure>();

    public RollingUpgradeChore(MasterServices masterServices) {
        this(masterServices.getConfiguration(), masterServices.getMasterProcedureExecutor(), masterServices.getTableDescriptors(), masterServices);
    }

    private RollingUpgradeChore(Configuration conf, ProcedureExecutor<MasterProcedureEnv> procedureExecutor, TableDescriptors tableDescriptors, Stoppable stopper) {
        super(RollingUpgradeChore.class.getSimpleName(), stopper, conf.getInt(ROLLING_UPGRADE_CHORE_PERIOD_SECONDS_KEY, 10), conf.getLong(ROLLING_UPGRADE_CHORE_DELAY_SECONDS_KEY, 30L), TimeUnit.SECONDS);
        this.procedureExecutor = procedureExecutor;
        this.tableDescriptors = tableDescriptors;
    }

    @Override
    protected void chore() {
        if (this.isCompletelyMigrateSFT(5)) {
            LOG.info("All Rolling-Upgrade tasks are complete, shutdown RollingUpgradeChore!");
            this.shutdown();
        }
    }

    private boolean isCompletelyMigrateSFT(int concurrentCount) {
        Map<String, TableDescriptor> migrateSFTTables;
        Iterator<InitializeStoreFileTrackerProcedure> iter = this.processingProcs.iterator();
        while (iter.hasNext()) {
            InitializeStoreFileTrackerProcedure proc = iter.next();
            if (!this.procedureExecutor.isFinished(proc.getProcId())) continue;
            iter.remove();
        }
        if (!this.processingProcs.isEmpty()) {
            return false;
        }
        try {
            migrateSFTTables = this.tableDescriptors.getAll().entrySet().stream().filter(entry -> {
                TableDescriptor td = (TableDescriptor)entry.getValue();
                return StringUtils.isEmpty(td.getValue("hbase.store.file-tracker.impl"));
            }).limit(concurrentCount).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (TableDescriptor)e.getValue()));
        }
        catch (IOException e2) {
            LOG.warn("Failed to migrate StoreFileTracker", (Throwable)e2);
            return false;
        }
        if (migrateSFTTables.isEmpty()) {
            LOG.info("There is no table to migrate StoreFileTracker!");
            return true;
        }
        for (Map.Entry<String, TableDescriptor> entry2 : migrateSFTTables.entrySet()) {
            TableDescriptor tableDescriptor = entry2.getValue();
            InitializeStoreFileTrackerProcedure proc = new InitializeStoreFileTrackerProcedure(this.procedureExecutor.getEnvironment(), tableDescriptor.getTableName());
            this.procedureExecutor.submitProcedure(proc);
            this.processingProcs.add(proc);
        }
        return false;
    }
}

