/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public final class DeflatingGzipEntityProducer
implements AsyncEntityProducer {
    private static final int IN_BUF = 8192;
    private static final int OUT_BUF = 8192;
    private final AsyncEntityProducer delegate;
    private final CRC32 crc = new CRC32();
    private final Deflater deflater = new Deflater(-1, true);
    private final byte[] in = new byte[8192];
    private final ByteBuffer outBuf = ByteBuffer.allocate(8192);
    private boolean headerSent = false;
    private boolean finished = false;
    private long uncompressed = 0L;
    private final AtomicBoolean released = new AtomicBoolean(false);

    public DeflatingGzipEntityProducer(AsyncEntityProducer delegate) {
        this.delegate = (AsyncEntityProducer)Args.notNull((Object)delegate, (String)"delegate");
        this.outBuf.flip();
    }

    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        return "gzip";
    }

    public boolean isChunked() {
        return true;
    }

    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    public int available() {
        return this.outBuf.hasRemaining() ? this.outBuf.remaining() : this.delegate.available();
    }

    public void produce(DataStreamChannel chan) throws IOException {
        this.flushOut(chan);
        if (this.finished) {
            return;
        }
        this.delegate.produce((DataStreamChannel)new InnerChannel(chan));
        if (this.delegate.available() == 0 && !this.finished) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflateToOut();
                this.flushOut(chan);
            }
            int crcVal = (int)this.crc.getValue();
            int size = (int)this.uncompressed;
            byte[] trailer = new byte[]{(byte)crcVal, (byte)(crcVal >>> 8), (byte)(crcVal >>> 16), (byte)(crcVal >>> 24), (byte)size, (byte)(size >>> 8), (byte)(size >>> 16), (byte)(size >>> 24)};
            chan.write(ByteBuffer.wrap(trailer));
            this.finished = true;
            chan.endStream();
        }
    }

    private void deflateToOut() {
        int n;
        this.outBuf.compact();
        byte[] arr = this.outBuf.array();
        int pos = this.outBuf.position();
        int lim = this.outBuf.limit();
        while ((n = this.deflater.deflate(arr, pos, lim - pos, 0)) > 0) {
            if ((pos += n) != lim) continue;
            ByteBuffer bigger = ByteBuffer.allocate(arr.length * 2);
            this.outBuf.flip();
            bigger.put(this.outBuf);
            this.outBuf.clear();
            this.outBuf.put(bigger);
            arr = this.outBuf.array();
            lim = this.outBuf.limit();
            pos = this.outBuf.position();
        }
        this.outBuf.position(pos);
        this.outBuf.flip();
    }

    private void flushOut(DataStreamChannel chan) throws IOException {
        int written;
        while (this.outBuf.hasRemaining() && (written = chan.write(this.outBuf)) != 0) {
        }
    }

    public void failed(Exception cause) {
        this.delegate.failed(cause);
    }

    public void releaseResources() {
        if (this.released.compareAndSet(false, true)) {
            this.deflater.end();
            this.delegate.releaseResources();
        }
    }

    private final class InnerChannel
    implements DataStreamChannel {
        private final DataStreamChannel chan;

        InnerChannel(DataStreamChannel chan) {
            this.chan = chan;
        }

        public void requestOutput() {
            this.chan.requestOutput();
        }

        public int write(ByteBuffer src) throws IOException {
            if (!DeflatingGzipEntityProducer.this.headerSent) {
                this.chan.write(ByteBuffer.wrap(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0}));
                DeflatingGzipEntityProducer.this.headerSent = true;
            }
            int consumed = 0;
            while (src.hasRemaining()) {
                int chunk = Math.min(src.remaining(), DeflatingGzipEntityProducer.this.in.length);
                src.get(DeflatingGzipEntityProducer.this.in, 0, chunk);
                DeflatingGzipEntityProducer.this.crc.update(DeflatingGzipEntityProducer.this.in, 0, chunk);
                DeflatingGzipEntityProducer.this.uncompressed = DeflatingGzipEntityProducer.this.uncompressed + (long)chunk;
                DeflatingGzipEntityProducer.this.deflater.setInput(DeflatingGzipEntityProducer.this.in, 0, chunk);
                consumed += chunk;
                DeflatingGzipEntityProducer.this.deflateToOut();
                DeflatingGzipEntityProducer.this.flushOut(this.chan);
            }
            return consumed;
        }

        public void endStream() {
        }

        public void endStream(List<? extends Header> t) {
            this.endStream();
        }
    }
}

