/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class JdbcQuerySingleResult
extends Response {
    @Nullable
    private Long cursorId;
    private boolean hasResultSet;
    private boolean hasNextResult;
    @Nullable
    private List<BinaryTupleReader> rowTuples;
    private boolean hasMoreData;
    @Nullable
    private List<JdbcColumnMeta> meta;
    private long updateCnt = -1L;

    public JdbcQuerySingleResult() {
    }

    public JdbcQuerySingleResult(int status, String err) {
        super(status, err);
    }

    public JdbcQuerySingleResult(@Nullable Long cursorId, List<BinaryTupleReader> rowTuples, List<JdbcColumnMeta> meta, boolean hasMoreData, boolean hasNextResult) {
        Objects.requireNonNull(rowTuples);
        this.cursorId = cursorId;
        this.rowTuples = rowTuples;
        this.meta = meta;
        this.hasMoreData = hasMoreData;
        this.hasNextResult = hasNextResult;
        this.hasResultSet = true;
    }

    public JdbcQuerySingleResult(@Nullable Long cursorId, long updateCnt, boolean hasNextResult) {
        this.updateCnt = updateCnt;
        this.cursorId = cursorId;
        this.hasNextResult = hasNextResult;
    }

    @Nullable
    public Long cursorId() {
        return this.cursorId;
    }

    @Nullable
    public List<BinaryTupleReader> items() {
        return this.rowTuples;
    }

    @Nullable
    public List<JdbcColumnMeta> meta() {
        return this.meta;
    }

    public boolean hasMoreData() {
        return this.hasMoreData;
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public boolean hasNextResult() {
        return this.hasNextResult;
    }

    public long updateCount() {
        return this.updateCnt;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.success()) {
            return;
        }
        packer.packLongNullable(this.cursorId);
        packer.packBoolean(this.hasResultSet);
        packer.packBoolean(this.hasNextResult);
        if (!this.hasResultSet) {
            packer.packLong(this.updateCnt);
            return;
        }
        assert (this.rowTuples != null);
        assert (this.meta != null);
        packer.packBoolean(this.hasMoreData);
        packer.packInt(this.meta.size());
        for (JdbcColumnMeta columnMeta : this.meta) {
            columnMeta.writeBinary(packer);
        }
        packer.packInt(this.rowTuples.size());
        for (BinaryTupleReader item : this.rowTuples) {
            packer.packByteBuffer(item.byteBuffer());
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.success()) {
            return;
        }
        this.cursorId = unpacker.tryUnpackNil() ? null : Long.valueOf(unpacker.unpackLong());
        this.hasResultSet = unpacker.unpackBoolean();
        this.hasNextResult = unpacker.unpackBoolean();
        if (!this.hasResultSet) {
            this.updateCnt = unpacker.unpackLong();
            return;
        }
        this.hasMoreData = unpacker.unpackBoolean();
        int count = unpacker.unpackInt();
        this.meta = new ArrayList<JdbcColumnMeta>(count);
        for (int i = 0; i < count; ++i) {
            JdbcColumnMeta columnMeta = new JdbcColumnMeta();
            columnMeta.readBinary(unpacker);
            this.meta.add(columnMeta);
        }
        int size = unpacker.unpackInt();
        this.rowTuples = new ArrayList<BinaryTupleReader>(size);
        for (int rowIdx = 0; rowIdx < size; ++rowIdx) {
            this.rowTuples.add(new BinaryTupleReader(count, unpacker.readBinary()));
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcQuerySingleResult.class, (Object)this);
    }
}

