/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.compute;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.TaskState;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.jetbrains.annotations.Nullable;

public class ClientComputeGetStateRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteComputeInternal compute) {
        UUID jobId = in.unpackUuid();
        return compute.stateAsync(jobId).thenApply(state -> out -> ClientComputeGetStateRequest.packJobState(out, state));
    }

    static void packJobState(ClientMessagePacker out, @Nullable JobState state) {
        if (state == null) {
            out.packNil();
        } else {
            out.packUuid(state.id());
            out.packInt(state.status().ordinal());
            out.packInstant(state.createTime());
            out.packInstant(state.startTime());
            out.packInstant(state.finishTime());
        }
    }

    static void packTaskState(ClientMessagePacker out, @Nullable TaskState state) {
        if (state == null) {
            out.packNil();
        } else {
            out.packUuid(state.id());
            out.packInt(state.status().ordinal());
            out.packInstant(state.createTime());
            out.packInstant(state.startTime());
            out.packInstant(state.finishTime());
        }
    }
}

