/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.table.Tuple;

public class TupleReader
implements MarshallerReader {
    private final Tuple tuple;
    private int index;

    public TupleReader(Tuple tuple) {
        this(tuple, 0);
    }

    TupleReader(Tuple tuple, int index) {
        this.tuple = tuple;
        this.index = index;
    }

    @Override
    public void skipValue() {
        ++this.index;
    }

    @Override
    public boolean readBoolean() {
        return this.tuple.booleanValue(this.index++);
    }

    @Override
    public Boolean readBooleanBoxed() {
        return (Boolean)this.tuple.value(this.index++);
    }

    @Override
    public byte readByte() {
        return this.tuple.byteValue(this.index++);
    }

    @Override
    public Byte readByteBoxed() {
        return (Byte)this.tuple.value(this.index++);
    }

    @Override
    public short readShort() {
        return this.tuple.shortValue(this.index++);
    }

    @Override
    public Short readShortBoxed() {
        return (Short)this.tuple.value(this.index++);
    }

    @Override
    public int readInt() {
        return this.tuple.intValue(this.index++);
    }

    @Override
    public Integer readIntBoxed() {
        return (Integer)this.tuple.value(this.index++);
    }

    @Override
    public long readLong() {
        return this.tuple.longValue(this.index++);
    }

    @Override
    public Long readLongBoxed() {
        return (Long)this.tuple.value(this.index++);
    }

    @Override
    public float readFloat() {
        return this.tuple.floatValue(this.index++);
    }

    @Override
    public Float readFloatBoxed() {
        return (Float)this.tuple.value(this.index++);
    }

    @Override
    public double readDouble() {
        return this.tuple.doubleValue(this.index++);
    }

    @Override
    public Double readDoubleBoxed() {
        return (Double)this.tuple.value(this.index++);
    }

    @Override
    public String readString() {
        return this.tuple.stringValue(this.index++);
    }

    @Override
    public UUID readUuid() {
        return this.tuple.uuidValue(this.index++);
    }

    @Override
    public byte[] readBytes() {
        return (byte[])this.tuple.value(this.index++);
    }

    @Override
    public BigDecimal readBigDecimal(int scale) {
        return new BigDecimal((BigInteger)this.tuple.value(this.index++), scale);
    }

    @Override
    public LocalDate readDate() {
        return this.tuple.dateValue(this.index++);
    }

    @Override
    public LocalTime readTime() {
        return this.tuple.timeValue(this.index++);
    }

    @Override
    public Instant readTimestamp() {
        return this.tuple.timestampValue(this.index++);
    }

    @Override
    public LocalDateTime readDateTime() {
        return this.tuple.datetimeValue(this.index++);
    }
}

