/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.Projection;

public class SwissObliqueMercatorProjection
extends Projection {
    private static final int NITER = 6;
    private double K;
    private double c;
    private double hlf_e;
    private double kR;
    private double cosp0;
    private double sinp0;
    private double phi0;

    @Override
    public void initialize() {
        super.initialize();
        this.phi0 = this.projectionLatitude;
        this.hlf_e = 0.5 * this.e;
        double cp = Math.cos(this.phi0);
        cp *= cp;
        this.c = Math.sqrt(1.0 + this.es * cp * cp * this.rone_es);
        double sp = Math.sin(this.phi0);
        this.sinp0 = sp / this.c;
        double phip0 = Math.asin(this.sinp0);
        this.cosp0 = Math.cos(phip0);
        this.K = Math.log(Math.tan(0.7853981633974483 + 0.5 * phip0)) - this.c * (Math.log(Math.tan(0.7853981633974483 + 0.5 * this.phi0)) - this.hlf_e * Math.log((1.0 + (sp *= this.e)) / (1.0 - sp)));
        this.kR = this.scaleFactor * Math.sqrt(this.one_es) / (1.0 - sp * sp);
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        double sp = this.e * Math.sin(lpphi);
        double phip = 2.0 * Math.atan(Math.exp(this.c * (Math.log(Math.tan(0.7853981633974483 + 0.5 * lpphi)) - this.hlf_e * Math.log((1.0 + sp) / (1.0 - sp))) + this.K)) - 1.5707963267948966;
        double lamp = this.c * lplam;
        double cp = Math.cos(phip);
        double phipp = Math.asin(this.cosp0 * Math.sin(phip) - this.sinp0 * cp * Math.cos(lamp));
        double lampp = Math.asin(cp * Math.sin(lamp) / Math.cos(phipp));
        xy.x = this.kR * lampp;
        xy.y = this.kR * Math.log(Math.tan(0.7853981633974483 + 0.5 * phipp));
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate lp) {
        int i;
        double phipp = 2.0 * (Math.atan(Math.exp(xyy / this.kR)) - 0.7853981633974483);
        double lampp = xyx / this.kR;
        double cp = Math.cos(phipp);
        double phip = Math.asin(this.cosp0 * Math.sin(phipp) + this.sinp0 * cp * Math.cos(lampp));
        double lamp = Math.asin(cp * Math.sin(lampp) / Math.cos(phip));
        double con = (this.K - Math.log(Math.tan(0.7853981633974483 + 0.5 * phip))) / this.c;
        for (i = 6; i != 0; --i) {
            double esp = this.e * Math.sin(phip);
            double delp = (con + Math.log(Math.tan(0.7853981633974483 + 0.5 * phip)) - this.hlf_e * Math.log((1.0 + esp) / (1.0 - esp))) * (1.0 - esp * esp) * Math.cos(phip) * this.rone_es;
            phip -= delp;
            if (Math.abs(delp) < 1.0E-10) break;
        }
        if (i == 0) {
            throw new ProjectionException("I_ERROR");
        }
        double lpphi = phip;
        double lplam = lamp / this.c;
        lp.x = lplam;
        lp.y = lpphi;
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Swiss Oblique Mercator";
    }
}

