/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.util;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;

public class GeneralDataTypeTransformer {
    public io.trino.spi.type.Type getTrinoType(Type type) {
        switch (type.name()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BYTE: {
                if (((Types.ByteType)type).signed()) {
                    return TinyintType.TINYINT;
                }
                return SmallintType.SMALLINT;
            }
            case SHORT: {
                if (((Types.ShortType)type).signed()) {
                    return SmallintType.SMALLINT;
                }
                return IntegerType.INTEGER;
            }
            case INTEGER: {
                if (((Types.IntegerType)type).signed()) {
                    return IntegerType.INTEGER;
                }
                return BigintType.BIGINT;
            }
            case LONG: {
                if (((Types.LongType)type).signed()) {
                    return BigintType.BIGINT;
                }
                return DecimalType.createDecimalType((int)20, (int)0);
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return DecimalType.createDecimalType((int)decimalType.precision(), (int)decimalType.scale());
            }
            case FIXEDCHAR: {
                return CharType.createCharType((int)((Types.FixedCharType)type).length());
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case VARCHAR: {
                return VarcharType.createVarcharType((int)((Types.VarCharType)type).length());
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIME: {
                return TimeType.TIME_MILLIS;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP_MILLIS;
            }
            case LIST: {
                return new ArrayType(this.getTrinoType(((Types.ListType)type).elementType()));
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)type;
                return new MapType(this.getTrinoType(mapType.keyType()), this.getTrinoType(mapType.valueType()), new TypeOperators());
            }
            case STRUCT: {
                Types.StructType structType = (Types.StructType)type;
                return this.gravitinoRowTypeToTrinoRowType(structType);
            }
            case UUID: {
                return UuidType.UUID;
            }
        }
        throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_GRAVITINO_DATATYPE, "Unsupported gravitino datatype: " + type);
    }

    private RowType gravitinoRowTypeToTrinoRowType(Types.StructType structType) {
        List fields = Arrays.stream(structType.fields()).map(field -> new RowType.Field(Optional.of(field.name()), this.getTrinoType(field.type()))).collect(Collectors.toList());
        return RowType.from(fields);
    }

    private Types.StructType trinoRowTypeToGravitinoRowType(RowType rowType) {
        Types.StructType.Field[] fields = (Types.StructType.Field[])rowType.getFields().stream().map(field -> Types.StructType.Field.nullableField((String)((String)field.getName().get()), (Type)this.getGravitinoType(field.getType()))).toArray(Types.StructType.Field[]::new);
        return Types.StructType.of((Types.StructType.Field[])fields);
    }

    public Type getGravitinoType(io.trino.spi.type.Type type) {
        Class<?> typeClass = type.getClass();
        if (typeClass == BooleanType.class) {
            return Types.BooleanType.get();
        }
        if (typeClass == TinyintType.class) {
            return Types.ByteType.get();
        }
        if (typeClass == SmallintType.class) {
            return Types.ShortType.get();
        }
        if (typeClass == IntegerType.class) {
            return Types.IntegerType.get();
        }
        if (typeClass == BigintType.class) {
            return Types.LongType.get();
        }
        if (typeClass == RealType.class) {
            return Types.FloatType.get();
        }
        if (typeClass == DoubleType.class) {
            return Types.DoubleType.get();
        }
        if (DecimalType.class.isAssignableFrom(typeClass)) {
            DecimalType decimalType = (DecimalType)type;
            return Types.DecimalType.of((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }
        if (typeClass == CharType.class) {
            return Types.FixedCharType.of((int)((CharType)type).getLength());
        }
        if (typeClass == VarcharType.class) {
            return Types.VarCharType.of((int)((VarcharType)type).getLength().orElse(0x7FFFFFFE));
        }
        if (typeClass == VarbinaryType.class) {
            return Types.BinaryType.get();
        }
        if (typeClass == DateType.class) {
            return Types.DateType.get();
        }
        if (typeClass == TimeType.class) {
            return Types.TimeType.get();
        }
        if (TimestampType.class.isAssignableFrom(typeClass)) {
            return Types.TimestampType.withoutTimeZone();
        }
        if (typeClass == ArrayType.class) {
            return Types.ListType.of((Type)this.getGravitinoType(((ArrayType)type).getElementType()), (boolean)true);
        }
        if (typeClass == MapType.class) {
            MapType mapType = (MapType)type;
            return Types.MapType.of((Type)this.getGravitinoType(mapType.getKeyType()), (Type)this.getGravitinoType(mapType.getValueType()), (boolean)true);
        }
        if (typeClass == RowType.class) {
            return this.trinoRowTypeToGravitinoRowType((RowType)type);
        }
        if (typeClass == UuidType.class) {
            return Types.UUIDType.get();
        }
        throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_TRINO_DATATYPE, "Unsupported Trino datatype: " + type);
    }
}

