/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.client.BaseSchemaCatalog;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericTopic;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.requests.TopicCreateRequest;
import org.apache.gravitino.dto.requests.TopicUpdateRequest;
import org.apache.gravitino.dto.requests.TopicUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.TopicResponse;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.messaging.DataLayout;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicCatalog;
import org.apache.gravitino.messaging.TopicChange;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

class MessagingCatalog
extends BaseSchemaCatalog
implements TopicCatalog {
    MessagingCatalog(Namespace namespace, String name, Catalog.Type type, String provider, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(namespace, name, type, provider, comment, properties, auditDTO, restClient);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public TopicCatalog asTopicCatalog() throws UnsupportedOperationException {
        return this;
    }

    @Override
    public NameIdentifier[] listTopics(Namespace namespace) throws NoSuchSchemaException {
        MessagingCatalog.checkTopicNamespace(namespace);
        Namespace fullNamespace = this.getTopicFullNamespace(namespace);
        EntityListResponse resp = this.restClient.get(MessagingCatalog.formatTopicRequestPath(fullNamespace), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.topicErrorHandler());
        resp.validate();
        return (NameIdentifier[])Arrays.stream(resp.identifiers()).map(ident -> NameIdentifier.of(ident.namespace().level(2), ident.name())).toArray(NameIdentifier[]::new);
    }

    @Override
    public Topic loadTopic(NameIdentifier ident) throws NoSuchTopicException {
        MessagingCatalog.checkTopicNameIdentifier(ident);
        Namespace fullNamespace = this.getTopicFullNamespace(ident.namespace());
        TopicResponse resp = this.restClient.get(MessagingCatalog.formatTopicRequestPath(fullNamespace) + "/" + ident.name(), TopicResponse.class, Collections.emptyMap(), ErrorHandlers.topicErrorHandler());
        resp.validate();
        return new GenericTopic(resp.getTopic(), this.restClient, fullNamespace);
    }

    @Override
    public Topic createTopic(NameIdentifier ident, String comment, DataLayout dataLayout, Map<String, String> properties) throws NoSuchSchemaException, TopicAlreadyExistsException {
        MessagingCatalog.checkTopicNameIdentifier(ident);
        Namespace fullNamespace = this.getTopicFullNamespace(ident.namespace());
        TopicCreateRequest req = TopicCreateRequest.builder().name(ident.name()).comment(comment).properties(properties).build();
        TopicResponse resp = this.restClient.post(MessagingCatalog.formatTopicRequestPath(fullNamespace), (RESTRequest)req, TopicResponse.class, Collections.emptyMap(), ErrorHandlers.topicErrorHandler());
        resp.validate();
        return new GenericTopic(resp.getTopic(), this.restClient, fullNamespace);
    }

    @Override
    public Topic alterTopic(NameIdentifier ident, TopicChange ... changes) throws NoSuchTopicException, IllegalArgumentException {
        MessagingCatalog.checkTopicNameIdentifier(ident);
        Namespace fullNamespace = this.getTopicFullNamespace(ident.namespace());
        List<TopicUpdateRequest> updates = Arrays.stream(changes).map(DTOConverters::toTopicUpdateRequest).collect(Collectors.toList());
        TopicUpdatesRequest updatesRequest = new TopicUpdatesRequest(updates);
        updatesRequest.validate();
        TopicResponse resp = this.restClient.put(MessagingCatalog.formatTopicRequestPath(fullNamespace) + "/" + ident.name(), (RESTRequest)updatesRequest, TopicResponse.class, Collections.emptyMap(), ErrorHandlers.topicErrorHandler());
        resp.validate();
        return new GenericTopic(resp.getTopic(), this.restClient, fullNamespace);
    }

    @Override
    public boolean dropTopic(NameIdentifier ident) {
        MessagingCatalog.checkTopicNameIdentifier(ident);
        Namespace fullNamespace = this.getTopicFullNamespace(ident.namespace());
        DropResponse resp = this.restClient.delete(MessagingCatalog.formatTopicRequestPath(fullNamespace) + "/" + ident.name(), DropResponse.class, Collections.emptyMap(), ErrorHandlers.topicErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @VisibleForTesting
    static String formatTopicRequestPath(Namespace ns) {
        Namespace schemaNs = Namespace.of(ns.level(0), ns.level(1));
        return MessagingCatalog.formatSchemaRequestPath(schemaNs) + "/" + ns.level(2) + "/topics";
    }

    static void checkTopicNamespace(Namespace namespace) {
        Namespace.check(namespace != null && namespace.length() == 1, "Topic namespace must be non-null and have 1 level, the input namespace is %s", namespace);
    }

    static void checkTopicNameIdentifier(NameIdentifier ident) {
        NameIdentifier.check(ident != null, "NameIdentifier must not be null", new Object[0]);
        NameIdentifier.check(ident.name() != null && !ident.name().isEmpty(), "NameIdentifier name must not be empty", new Object[0]);
        MessagingCatalog.checkTopicNamespace(ident.namespace());
    }

    private Namespace getTopicFullNamespace(Namespace topicNamespace) {
        return Namespace.of(this.catalogNamespace().level(0), this.name(), topicNamespace.level(0));
    }

    static class Builder
    extends CatalogDTO.Builder<Builder> {
        private RESTClient restClient;
        private Namespace namespace;

        private Builder() {
        }

        Builder withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        Builder withRestClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        @Override
        public MessagingCatalog build() {
            Namespace.check(this.namespace != null && this.namespace.length() == 1, "Catalog namespace must be non-null and have 1 level, the input namespace is %s", this.namespace);
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "name must not be blank");
            Preconditions.checkArgument(this.type != null, "type must not be null");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.provider), "provider must not be blank");
            Preconditions.checkArgument(this.audit != null, "audit must not be null");
            Preconditions.checkArgument(this.restClient != null, "restClient must be set");
            return new MessagingCatalog(this.namespace, this.name, this.type, this.provider, this.comment, this.properties, this.audit, this.restClient);
        }
    }
}

