/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Random;
import org.apache.gravitino.shaded.com.google.common.base.Joiner;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.base.Splitter;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableMap;

public class RESTUtils {
    private static final Joiner.MapJoiner FORM_JOINER = Joiner.on("&").withKeyValueSeparator("=");
    private static final Splitter.MapSplitter FORM_SPLITTER = Splitter.on("&").withKeyValueSeparator("=");

    private RESTUtils() {
    }

    public static String stripTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String encodeFormData(Map<?, ?> formData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        formData.forEach((key, value) -> builder.put(RESTUtils.encodeString(String.valueOf(key)), RESTUtils.encodeString(String.valueOf(value))));
        return FORM_JOINER.join(builder.build());
    }

    public static Map<String, String> decodeFormData(String formString) {
        return FORM_SPLITTER.split(formString).entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> RESTUtils.decodeString((String)e.getKey()), e -> RESTUtils.decodeString((String)e.getValue())));
    }

    public static String encodeString(String toEncode) {
        Preconditions.checkArgument(toEncode != null, "Invalid string to encode: null");
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL encode '%s': UTF-8 encoding is not supported", toEncode), e);
        }
    }

    public static String decodeString(String encoded) {
        Preconditions.checkArgument(encoded != null, "Invalid string to decode: null");
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(String.format("Failed to URL decode '%s': UTF-8 encoding is not supported", encoded), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findAvailablePort(int portRangeStart, int portRangeEnd) throws IOException {
        if (portRangeStart > portRangeEnd) {
            throw new IOException("Invalid port range: " + portRangeStart + ":" + portRangeEnd);
        }
        if (portRangeStart == 0 && portRangeEnd == 0) {
            try (ServerSocket socket = new ServerSocket(0);){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException e) {
                throw new IOException("Failed to allocate a random port", e);
            }
        }
        if (portRangeStart == portRangeEnd) {
            try (ServerSocket socket = new ServerSocket(portRangeStart);){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException e) {
                throw new IOException("Failed to allocate the specified port: " + portRangeStart, e);
            }
        }
        if (portRangeStart < 1024) throw new IOException("port number must be 0 or in [1024, 65535]");
        if (portRangeEnd > 65535) {
            throw new IOException("port number must be 0 or in [1024, 65535]");
        }
        Random random = new Random();
        int maxRetry = 200;
        int i = portRangeStart;
        while (true) {
            if (i > portRangeEnd) {
                if (i >= portRangeStart + 200) throw new IOException("No available port in the range: " + portRangeStart + ":" + portRangeEnd);
            }
            int randomNumber = random.nextInt(portRangeEnd - portRangeStart + 1) + portRangeStart;
            try (ServerSocket socket = new ServerSocket(randomNumber);){
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException iOException) {
                ++i;
                continue;
            }
            break;
        }
    }
}

