/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe.internal;

import io.trino.jdbc.$internal.dev.failsafe.ExecutionContext;
import io.trino.jdbc.$internal.dev.failsafe.event.EventListener;
import io.trino.jdbc.$internal.dev.failsafe.event.ExecutionAttemptedEvent;
import io.trino.jdbc.$internal.dev.failsafe.event.ExecutionCompletedEvent;
import io.trino.jdbc.$internal.dev.failsafe.event.ExecutionScheduledEvent;
import io.trino.jdbc.$internal.dev.failsafe.spi.ExecutionResult;
import java.time.Duration;

public interface EventHandler<R> {
    public void handle(ExecutionResult<R> var1, ExecutionContext<R> var2);

    public static <R> EventHandler<R> ofExecutionCompleted(EventListener<ExecutionCompletedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionCompletedEvent(result.getResult(), result.getException(), context));
    }

    public static <R> EventHandler<R> ofExecutionAttempted(EventListener<ExecutionAttemptedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionAttemptedEvent(result.getResult(), result.getException(), context));
    }

    public static <R> EventHandler<R> ofExecutionScheduled(EventListener<ExecutionScheduledEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionScheduledEvent(result.getResult(), result.getException(), Duration.ofNanos(result.getDelay()), context));
    }
}

