/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import java.util.Map;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableMap;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class GCSTokenCredential
implements Credential {
    public static final String GCS_TOKEN_CREDENTIAL_TYPE = "gcs-token";
    public static final String GCS_TOKEN_NAME = "token";
    private final String token;
    private final long expireMs;

    public GCSTokenCredential(String token, long expireMs) {
        Preconditions.checkArgument(StringUtils.isNotBlank(token), "GCS session token should not be null");
        this.token = token;
        this.expireMs = expireMs;
    }

    @Override
    public String credentialType() {
        return GCS_TOKEN_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return this.expireMs;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder<String, String>().put(GCS_TOKEN_NAME, this.token).build();
    }

    public String token() {
        return this.token;
    }
}

