/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.async;

import com.alipay.common.tracer.core.async.SofaTracerCallable;
import com.alipay.common.tracer.core.async.SofaTracerRunnable;
import com.alipay.common.tracer.core.async.TracedExecutorService;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TracerScheduleExecutorService
extends TracedExecutorService
implements ScheduledExecutorService {
    public TracerScheduleExecutorService(ScheduledExecutorService delegate) {
        super(delegate, SofaTraceContextHolder.getSofaTraceContext());
    }

    public TracerScheduleExecutorService(ScheduledExecutorService delegate, SofaTraceContext traceContext) {
        super(delegate, traceContext);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        SofaTracerRunnable r = new SofaTracerRunnable(command, this.traceContext);
        return this.getScheduledExecutorService().schedule(r, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        SofaTracerCallable<V> c = new SofaTracerCallable<V>(callable, this.traceContext);
        return this.getScheduledExecutorService().schedule(c, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        SofaTracerRunnable r = new SofaTracerRunnable(command, this.traceContext);
        return this.getScheduledExecutorService().scheduleAtFixedRate(r, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        SofaTracerRunnable r = new SofaTracerRunnable(command, this.traceContext);
        return this.getScheduledExecutorService().scheduleWithFixedDelay(r, initialDelay, delay, unit);
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.delegate;
    }
}

