/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.type;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.reflect.TypeRef;

public class ScalaTypes {
    private static volatile Class<?> SCALA_MAP_TYPE;
    private static volatile Class<?> SCALA_SEQ_TYPE;
    private static volatile Class<?> SCALA_ITERABLE_TYPE;
    private static volatile Type SCALA_ITERATOR_RETURN_TYPE;
    private static volatile Type SCALA_NEXT_RETURN_TYPE;

    public static Class<?> getScalaMapType() {
        if (SCALA_MAP_TYPE == null) {
            SCALA_MAP_TYPE = ReflectionUtils.loadClass("scala.collection.Map");
        }
        return SCALA_MAP_TYPE;
    }

    public static Class<?> getScalaSeqType() {
        if (SCALA_SEQ_TYPE == null) {
            SCALA_SEQ_TYPE = ReflectionUtils.loadClass("scala.collection.Seq");
        }
        return SCALA_SEQ_TYPE;
    }

    public static Class<?> getScalaIterableType() {
        if (SCALA_ITERABLE_TYPE == null) {
            SCALA_ITERABLE_TYPE = ReflectionUtils.loadClass("scala.collection.Iterable");
        }
        return SCALA_ITERABLE_TYPE;
    }

    public static TypeRef<?> getElementType(TypeRef typeRef) {
        TypeRef<?> supertype = typeRef.getSupertype(ScalaTypes.getScalaIterableType());
        return supertype.resolveType(ScalaTypes.getScalaIteratorReturnType()).resolveType(ScalaTypes.getScalaNextReturnType());
    }

    private static Type getScalaIteratorReturnType() {
        if (SCALA_ITERATOR_RETURN_TYPE == null) {
            try {
                SCALA_ITERATOR_RETURN_TYPE = ScalaTypes.getScalaIterableType().getMethod("iterator", new Class[0]).getGenericReturnType();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return SCALA_ITERATOR_RETURN_TYPE;
    }

    private static Type getScalaNextReturnType() {
        if (SCALA_NEXT_RETURN_TYPE == null) {
            Class<?> scalaIteratorType = ReflectionUtils.loadClass("scala.collection.Iterator");
            try {
                SCALA_NEXT_RETURN_TYPE = scalaIteratorType.getMethod("next", new Class[0]).getGenericReturnType();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return SCALA_NEXT_RETURN_TYPE;
    }

    public static Tuple2<TypeRef<?>, TypeRef<?>> getMapKeyValueType(TypeRef typeRef) {
        TypeRef<?> kvTupleType = ScalaTypes.getElementType(typeRef);
        ParameterizedType type = (ParameterizedType)kvTupleType.getType();
        Type[] types = type.getActualTypeArguments();
        return Tuple2.of(TypeRef.of(types[0]), TypeRef.of(types[1]));
    }
}

