/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.fury.memory.Platform;

public class StringUtils {
    public static final long MULTI_CHARS_NON_LATIN_MASK;
    public static final long MULTI_CHARS_NON_ASCII_MASK;
    private static final char[] BASE16_CHARS2;

    public static String encodeHexString(byte[] data) {
        StringBuilder result = new StringBuilder(data.length * 2);
        for (byte b : data) {
            result.append(BASE16_CHARS2[b >>> 4 & 0xF]).append(BASE16_CHARS2[b & 0xF]);
        }
        return result.toString();
    }

    public static String format(String str, Object ... args) {
        StringBuilder builder = new StringBuilder(str);
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("args length must be multiple of 2, but get " + args.length);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            values.put(args[i].toString(), args[i + 1].toString());
        }
        for (Map.Entry entry : values.entrySet()) {
            int start;
            String pattern = "${" + (String)entry.getKey() + "}";
            String value = (String)entry.getValue();
            while ((start = builder.indexOf(pattern)) != -1) {
                builder.replace(start, start + pattern.length(), value);
            }
        }
        return builder.toString();
    }

    public static String stripBlankLines(String str) {
        String[] split;
        StringBuilder builder = new StringBuilder();
        for (String s : split = str.split("\n")) {
            if (s.trim().isEmpty()) continue;
            builder.append(s).append('\n');
        }
        if (builder.charAt(builder.length() - 1) == '\n') {
            return builder.toString();
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static String random(int size) {
        return StringUtils.random(size, new Random());
    }

    public static String random(int size, int rand) {
        return StringUtils.random(size, new Random(rand));
    }

    public static String random(int size, Random random) {
        char[] chars = new char[size];
        int start = 32;
        int end = 123;
        int gap = end - start;
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)(start + random.nextInt(gap));
        }
        return new String(chars);
    }

    public static String capitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String uncapitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static void shuffle(StringBuilder sb) {
        StringUtils.shuffle(sb, 7);
    }

    public static void shuffle(StringBuilder sb, int seed) {
        Random rand = new Random(seed);
        for (int i = sb.length() - 1; i > 1; --i) {
            int swapWith = rand.nextInt(i);
            char tmp = sb.charAt(swapWith);
            sb.setCharAt(swapWith, sb.charAt(i));
            sb.setCharAt(i, tmp);
        }
    }

    public static String repeat(String str, int numRepeat) {
        StringBuilder builder = new StringBuilder(numRepeat * str.length());
        for (int i = 0; i < numRepeat; ++i) {
            builder.append(str);
        }
        return builder.toString();
    }

    public static String lowerUnderscoreToLowerCamelCase(String lowerUnderscore) {
        int index;
        StringBuilder builder = new StringBuilder();
        int length = lowerUnderscore.length();
        int fromIndex = 0;
        while ((index = lowerUnderscore.indexOf(95, fromIndex)) != -1) {
            char symbol;
            builder.append(lowerUnderscore, fromIndex, index);
            if (length >= index + 1 && (symbol = lowerUnderscore.charAt(index + 1)) >= 'a' && symbol <= 'z') {
                builder.append(Character.toUpperCase(symbol));
                fromIndex = index + 2;
                continue;
            }
            fromIndex = index + 1;
        }
        if (fromIndex < length) {
            builder.append(lowerUnderscore, fromIndex, length);
        }
        return builder.toString();
    }

    public static String lowerCamelToLowerUnderscore(String lowerCamel) {
        StringBuilder builder = new StringBuilder();
        int length = lowerCamel.length();
        int fromIndex = 0;
        for (int i = 0; i < length; ++i) {
            char symbol = lowerCamel.charAt(i);
            if (symbol < 'A' || symbol > 'Z') continue;
            builder.append(lowerCamel, fromIndex, i).append('_').append(Character.toLowerCase(symbol));
            fromIndex = i + 1;
        }
        if (fromIndex < length) {
            builder.append(lowerCamel, fromIndex, length);
        }
        return builder.toString();
    }

    public static boolean isLatin(char[] chars) {
        return StringUtils.isLatin(chars, 0);
    }

    public static boolean isLatin(char[] chars, int start) {
        if (start > chars.length) {
            return false;
        }
        int byteOffset = start << 1;
        int numChars = chars.length;
        int vectorizedLen = numChars >> 2;
        int vectorizedChars = vectorizedLen << 2;
        int endOffset = Platform.CHAR_ARRAY_OFFSET + (vectorizedChars << 1);
        boolean isLatin = true;
        for (int offset = Platform.CHAR_ARRAY_OFFSET + byteOffset; offset < endOffset; offset += 8) {
            long multiChars = Platform.getLong(chars, offset);
            if ((multiChars & MULTI_CHARS_NON_LATIN_MASK) == 0L) continue;
            isLatin = false;
            break;
        }
        if (isLatin) {
            for (int i = vectorizedChars; i < numChars; ++i) {
                if (chars[i] <= '\u00ff') continue;
                isLatin = false;
                break;
            }
        }
        return isLatin;
    }

    static {
        BASE16_CHARS2 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (Platform.IS_LITTLE_ENDIAN) {
            MULTI_CHARS_NON_LATIN_MASK = -71777214294589696L;
            MULTI_CHARS_NON_ASCII_MASK = -35747867511423104L;
        } else {
            MULTI_CHARS_NON_LATIN_MASK = 0xFF00FF00FF00FFL;
            MULTI_CHARS_NON_ASCII_MASK = -9151454082924314369L;
        }
    }
}

