/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PromTargetsModel {
    private static final String LABEL_METRICS_PATH = "__metrics_path__";
    private static final String LABEL_SCHEME = "__scheme__";
    private static final String LABEL_JOB_NAME = "job";
    private static final String LABEL_CLUSTER = "cluster";
    private final Map<String, String> labels = new HashMap();
    private Set<String> targets = new HashSet();

    private PromTargetsModel() {
    }

    public static PromTargetsModel of() {
        return new PromTargetsModel();
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public PromTargetsModel setTargets(Set<String> targets) {
        if (targets != null) {
            this.targets = targets;
        }
        return this;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public PromTargetsModel addTarget(String target) {
        if (target == null) {
            return this;
        }
        this.targets.add(target);
        return this;
    }

    public PromTargetsModel setMetricsPath(String path) {
        return this.addLabel(LABEL_METRICS_PATH, path);
    }

    public PromTargetsModel setScheme(String scheme) {
        return this.addLabel(LABEL_SCHEME, scheme);
    }

    public PromTargetsModel setClusterId(String clusterId) {
        return this.addLabel(LABEL_CLUSTER, clusterId);
    }

    public PromTargetsModel addLabel(String label, String value) {
        if (label == null || value == null) {
            return this;
        }
        this.labels.put(label, value);
        return this;
    }

    public String toString() {
        return "PromTargetModel{targets=" + String.valueOf(this.targets) + ", labels=" + String.valueOf(this.labels) + "}";
    }
}

