/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.rest;

import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttpBasicAuthInterceptor
implements Interceptor {
    private final String credentials;

    public OkHttpBasicAuthInterceptor(String user, String password) {
        this.credentials = Credentials.basic((String)user, (String)password);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") == null) {
            Request authenticatedRequest = request.newBuilder().header("Authorization", this.credentials).build();
            return chain.proceed(authenticatedRequest);
        }
        return chain.proceed(request);
    }
}

