/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.hugegraph.store.node.AppConfig;
import org.apache.hugegraph.store.options.JobOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AppConfig {
    private static int cpus = Runtime.getRuntime().availableProcessors();
    @Value(value="${pdserver.address}")
    private String pdServerAddress;
    @Value(value="${grpc.host}")
    private String host;
    @Value(value="${grpc.port}")
    private int grpcPort;
    @Value(value="${grpc.server.wait-time: 3600}")
    private int serverWaitTime;
    @Value(value="${server.port}")
    private int restPort;
    @Value(value="${app.data-path: store}")
    private String dataPath;
    @Value(value="${app.placeholder-size: 10}")
    private Integer placeholderSize;
    @Value(value="${app.raft-path:}")
    private String raftPath;
    @Value(value="${app.fake-pd: false}")
    private boolean fakePd;
    @Autowired
    private Raft raft;
    @Autowired
    private ArthasConfig arthasConfig;
    @Autowired
    private FakePdConfig fakePdConfig;
    @Autowired
    private LabelConfig labelConfig;
    @Autowired
    private RocksdbConfig rocksdbConfig;
    @Autowired
    private ThreadPoolGrpc threadPoolGrpc;
    @Autowired
    private ThreadPoolScan threadPoolScan;
    @Autowired
    private JobConfig jobConfig;
    @Autowired
    private QueryPushDownConfig queryPushDownConfig;

    public String getRaftPath() {
        if (this.raftPath == null || this.raftPath.length() == 0) {
            return this.dataPath;
        }
        return this.raftPath;
    }

    @PostConstruct
    public void init() {
        Map rocksdb;
        Runtime rt = Runtime.getRuntime();
        if (this.threadPoolScan.core == 0) {
            this.threadPoolScan.core = rt.availableProcessors() * 4;
        }
        if (!(rocksdb = this.rocksdbConfig.rocksdb).containsKey("total_memory_size") || "0".equals(rocksdb.get("total_memory_size"))) {
            rocksdb.put("total_memory_size", Long.toString(rt.maxMemory()));
        }
        long totalMemory = Long.parseLong((String)this.rocksdbConfig.rocksdb.get("total_memory_size"));
        if (this.raft.getDisruptorBufferSize() == 0) {
            int size = (int)(totalMemory / 1000L / 1000L / 1000L);
            size = (int)Math.pow(2.0, Math.round(Math.log(size) / Math.log(2.0))) * 32;
            this.raft.setDisruptorBufferSize(size);
        }
        if (!rocksdb.containsKey("write_buffer_size") || "0".equals(rocksdb.get("write_buffer_size"))) {
            rocksdb.put("write_buffer_size", Long.toString(totalMemory / 1000L));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AppConfig \n").append("rocksdb:\n");
        this.rocksdbConfig.rocksdb.forEach((k, v) -> builder.append("\t" + k + ":").append((String)v).append("\n"));
        builder.append("raft:\n");
        builder.append("\tdisruptorBufferSize: " + this.raft.disruptorBufferSize);
        return builder.toString();
    }

    public String getStoreServerAddress() {
        return String.format("%s:%d", this.host, this.grpcPort);
    }

    public Map<String, Object> getRocksdbConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        this.rocksdbConfig.rocksdb.forEach((k, v) -> config.put("rocksdb." + k, v));
        return config;
    }

    public JobOptions getJobOptions() {
        JobOptions jobOptions = new JobOptions();
        jobOptions.setCore(this.jobConfig.getCore() == 0 ? cpus : this.jobConfig.getCore());
        jobOptions.setMax(this.jobConfig.getMax() == 0 ? cpus * 4 : this.jobConfig.getMax());
        jobOptions.setQueueSize(this.jobConfig.getQueueSize());
        jobOptions.setBatchSize(this.jobConfig.getBatchSize());
        int uninterruptibleCore = jobOptions.getUninterruptibleCore();
        jobOptions.setUninterruptibleCore(uninterruptibleCore == 0 ? cpus : uninterruptibleCore);
        int uninterruptibleMax = jobOptions.getUninterruptibleMax();
        jobOptions.setUninterruptibleMax(uninterruptibleMax == 0 ? cpus * 4 : uninterruptibleMax);
        jobOptions.setUninterruptibleQueueSize(this.jobConfig.getUninterruptibleQueueSize());
        return jobOptions;
    }

    public String getPdServerAddress() {
        return this.pdServerAddress;
    }

    public String getHost() {
        return this.host;
    }

    public int getGrpcPort() {
        return this.grpcPort;
    }

    public int getServerWaitTime() {
        return this.serverWaitTime;
    }

    public int getRestPort() {
        return this.restPort;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public Integer getPlaceholderSize() {
        return this.placeholderSize;
    }

    public boolean isFakePd() {
        return this.fakePd;
    }

    public Raft getRaft() {
        return this.raft;
    }

    public ArthasConfig getArthasConfig() {
        return this.arthasConfig;
    }

    public FakePdConfig getFakePdConfig() {
        return this.fakePdConfig;
    }

    public LabelConfig getLabelConfig() {
        return this.labelConfig;
    }

    public ThreadPoolGrpc getThreadPoolGrpc() {
        return this.threadPoolGrpc;
    }

    public ThreadPoolScan getThreadPoolScan() {
        return this.threadPoolScan;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    public QueryPushDownConfig getQueryPushDownConfig() {
        return this.queryPushDownConfig;
    }

    public void setPdServerAddress(String pdServerAddress) {
        this.pdServerAddress = pdServerAddress;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setGrpcPort(int grpcPort) {
        this.grpcPort = grpcPort;
    }

    public void setServerWaitTime(int serverWaitTime) {
        this.serverWaitTime = serverWaitTime;
    }

    public void setRestPort(int restPort) {
        this.restPort = restPort;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setPlaceholderSize(Integer placeholderSize) {
        this.placeholderSize = placeholderSize;
    }

    public void setRaftPath(String raftPath) {
        this.raftPath = raftPath;
    }

    public void setFakePd(boolean fakePd) {
        this.fakePd = fakePd;
    }

    public void setRaft(Raft raft) {
        this.raft = raft;
    }

    public void setArthasConfig(ArthasConfig arthasConfig) {
        this.arthasConfig = arthasConfig;
    }

    public void setFakePdConfig(FakePdConfig fakePdConfig) {
        this.fakePdConfig = fakePdConfig;
    }

    public void setLabelConfig(LabelConfig labelConfig) {
        this.labelConfig = labelConfig;
    }

    public void setRocksdbConfig(RocksdbConfig rocksdbConfig) {
        this.rocksdbConfig = rocksdbConfig;
    }

    public void setThreadPoolGrpc(ThreadPoolGrpc threadPoolGrpc) {
        this.threadPoolGrpc = threadPoolGrpc;
    }

    public void setThreadPoolScan(ThreadPoolScan threadPoolScan) {
        this.threadPoolScan = threadPoolScan;
    }

    public void setJobConfig(JobConfig jobConfig) {
        this.jobConfig = jobConfig;
    }

    public void setQueryPushDownConfig(QueryPushDownConfig queryPushDownConfig) {
        this.queryPushDownConfig = queryPushDownConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppConfig)) {
            return false;
        }
        AppConfig other = (AppConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getGrpcPort() != other.getGrpcPort()) {
            return false;
        }
        if (this.getServerWaitTime() != other.getServerWaitTime()) {
            return false;
        }
        if (this.getRestPort() != other.getRestPort()) {
            return false;
        }
        if (this.isFakePd() != other.isFakePd()) {
            return false;
        }
        Integer this$placeholderSize = this.getPlaceholderSize();
        Integer other$placeholderSize = other.getPlaceholderSize();
        if (this$placeholderSize == null ? other$placeholderSize != null : !((Object)this$placeholderSize).equals(other$placeholderSize)) {
            return false;
        }
        String this$pdServerAddress = this.getPdServerAddress();
        String other$pdServerAddress = other.getPdServerAddress();
        if (this$pdServerAddress == null ? other$pdServerAddress != null : !this$pdServerAddress.equals(other$pdServerAddress)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$raftPath = this.getRaftPath();
        String other$raftPath = other.getRaftPath();
        if (this$raftPath == null ? other$raftPath != null : !this$raftPath.equals(other$raftPath)) {
            return false;
        }
        Raft this$raft = this.getRaft();
        Raft other$raft = other.getRaft();
        if (this$raft == null ? other$raft != null : !this$raft.equals(other$raft)) {
            return false;
        }
        ArthasConfig this$arthasConfig = this.getArthasConfig();
        ArthasConfig other$arthasConfig = other.getArthasConfig();
        if (this$arthasConfig == null ? other$arthasConfig != null : !this$arthasConfig.equals(other$arthasConfig)) {
            return false;
        }
        FakePdConfig this$fakePdConfig = this.getFakePdConfig();
        FakePdConfig other$fakePdConfig = other.getFakePdConfig();
        if (this$fakePdConfig == null ? other$fakePdConfig != null : !this$fakePdConfig.equals(other$fakePdConfig)) {
            return false;
        }
        LabelConfig this$labelConfig = this.getLabelConfig();
        LabelConfig other$labelConfig = other.getLabelConfig();
        if (this$labelConfig == null ? other$labelConfig != null : !this$labelConfig.equals(other$labelConfig)) {
            return false;
        }
        Map this$rocksdbConfig = this.getRocksdbConfig();
        Map other$rocksdbConfig = other.getRocksdbConfig();
        if (this$rocksdbConfig == null ? other$rocksdbConfig != null : !((Object)this$rocksdbConfig).equals(other$rocksdbConfig)) {
            return false;
        }
        ThreadPoolGrpc this$threadPoolGrpc = this.getThreadPoolGrpc();
        ThreadPoolGrpc other$threadPoolGrpc = other.getThreadPoolGrpc();
        if (this$threadPoolGrpc == null ? other$threadPoolGrpc != null : !this$threadPoolGrpc.equals(other$threadPoolGrpc)) {
            return false;
        }
        ThreadPoolScan this$threadPoolScan = this.getThreadPoolScan();
        ThreadPoolScan other$threadPoolScan = other.getThreadPoolScan();
        if (this$threadPoolScan == null ? other$threadPoolScan != null : !this$threadPoolScan.equals(other$threadPoolScan)) {
            return false;
        }
        JobConfig this$jobConfig = this.getJobConfig();
        JobConfig other$jobConfig = other.getJobConfig();
        if (this$jobConfig == null ? other$jobConfig != null : !this$jobConfig.equals(other$jobConfig)) {
            return false;
        }
        QueryPushDownConfig this$queryPushDownConfig = this.getQueryPushDownConfig();
        QueryPushDownConfig other$queryPushDownConfig = other.getQueryPushDownConfig();
        return !(this$queryPushDownConfig == null ? other$queryPushDownConfig != null : !this$queryPushDownConfig.equals(other$queryPushDownConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGrpcPort();
        result = result * 59 + this.getServerWaitTime();
        result = result * 59 + this.getRestPort();
        result = result * 59 + (this.isFakePd() ? 79 : 97);
        Integer $placeholderSize = this.getPlaceholderSize();
        result = result * 59 + ($placeholderSize == null ? 43 : ((Object)$placeholderSize).hashCode());
        String $pdServerAddress = this.getPdServerAddress();
        result = result * 59 + ($pdServerAddress == null ? 43 : $pdServerAddress.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $raftPath = this.getRaftPath();
        result = result * 59 + ($raftPath == null ? 43 : $raftPath.hashCode());
        Raft $raft = this.getRaft();
        result = result * 59 + ($raft == null ? 43 : $raft.hashCode());
        ArthasConfig $arthasConfig = this.getArthasConfig();
        result = result * 59 + ($arthasConfig == null ? 43 : $arthasConfig.hashCode());
        FakePdConfig $fakePdConfig = this.getFakePdConfig();
        result = result * 59 + ($fakePdConfig == null ? 43 : $fakePdConfig.hashCode());
        LabelConfig $labelConfig = this.getLabelConfig();
        result = result * 59 + ($labelConfig == null ? 43 : $labelConfig.hashCode());
        Map $rocksdbConfig = this.getRocksdbConfig();
        result = result * 59 + ($rocksdbConfig == null ? 43 : ((Object)$rocksdbConfig).hashCode());
        ThreadPoolGrpc $threadPoolGrpc = this.getThreadPoolGrpc();
        result = result * 59 + ($threadPoolGrpc == null ? 43 : $threadPoolGrpc.hashCode());
        ThreadPoolScan $threadPoolScan = this.getThreadPoolScan();
        result = result * 59 + ($threadPoolScan == null ? 43 : $threadPoolScan.hashCode());
        JobConfig $jobConfig = this.getJobConfig();
        result = result * 59 + ($jobConfig == null ? 43 : $jobConfig.hashCode());
        QueryPushDownConfig $queryPushDownConfig = this.getQueryPushDownConfig();
        result = result * 59 + ($queryPushDownConfig == null ? 43 : $queryPushDownConfig.hashCode());
        return result;
    }
}

