/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.struct.schema;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.IdGenerator;
import org.apache.hugegraph.struct.schema.IndexLabel;
import org.apache.hugegraph.struct.schema.PropertyKey;
import org.apache.hugegraph.struct.schema.SchemaLabel;
import org.apache.hugegraph.struct.schema.Userdata;
import org.apache.hugegraph.struct.schema.builder.SchemaBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.IdStrategy;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.GraphUtils;

public class VertexLabel
extends SchemaLabel {
    public static final VertexLabel NONE = new VertexLabel(null, NONE_ID, "~undefined");
    public static final VertexLabel GENERAL = new VertexLabel(null, NONE_ID, "~general_vl");
    private static final Id OLAP_VL_ID = IdGenerator.of(-7L);
    private static final String OLAP_VL_NAME = "*olap";
    public static final VertexLabel OLAP_VL = new VertexLabel(null, OLAP_VL_ID, "*olap");
    public static final String GENERAL_VL = "~general_vl";
    private IdStrategy idStrategy = IdStrategy.DEFAULT;
    private final List<Id> primaryKeys = new ArrayList<Id>();

    public VertexLabel(HugeGraphSupplier graph, Id id, String name) {
        super(graph, id, name);
    }

    @Override
    public HugeType type() {
        return HugeType.VERTEX_LABEL;
    }

    public boolean olap() {
        return OLAP_VL.id().equals(this.id());
    }

    public IdStrategy idStrategy() {
        return this.idStrategy;
    }

    public void idStrategy(IdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public List<Id> primaryKeys() {
        return Collections.unmodifiableList(this.primaryKeys);
    }

    public void primaryKey(Id id) {
        this.primaryKeys.add(id);
    }

    public void primaryKeys(Id ... ids) {
        this.primaryKeys.addAll(Arrays.asList(ids));
    }

    @Override
    public Set<Id> extendProperties() {
        HashSet<Id> properties = new HashSet<Id>();
        properties.addAll(this.properties());
        properties.addAll(this.primaryKeys);
        this.graph().propertyKeys().stream().forEach(pk -> {
            if (pk.olap()) {
                properties.add(pk.id());
            }
        });
        return Collections.unmodifiableSet(properties);
    }

    @Override
    public Set<Id> extendIndexLabels() {
        HashSet<Id> indexes = new HashSet<Id>();
        indexes.addAll(this.indexLabels());
        for (IndexLabel il : this.graph.indexLabels()) {
            if (!il.olap()) continue;
            indexes.add(il.id());
        }
        return ImmutableSet.copyOf(indexes);
    }

    public boolean existsLinkLabel() {
        return this.graph().existsLinkLabel(this.id());
    }

    public boolean hasSameContent(VertexLabel other) {
        return super.hasSameContent(other) && this.idStrategy == other.idStrategy && Objects.equal(this.graph.mapPkId2Name(this.primaryKeys), other.graph.mapPkId2Name(other.primaryKeys));
    }

    public static VertexLabel undefined(HugeGraphSupplier graph) {
        return new VertexLabel(graph, NONE_ID, "~undefined");
    }

    public static VertexLabel undefined(HugeGraphSupplier graph, Id id) {
        return new VertexLabel(graph, id, "~undefined");
    }

    public String convert2Groovy(boolean attachIdFlag) {
        PropertyKey pk;
        StringBuilder builder = new StringBuilder("graph.schema().");
        if (!attachIdFlag) {
            builder.append("vertexLabel").append("('").append(this.name()).append("')");
        } else {
            builder.append("vertexLabel").append("(").append(this.longId()).append(", '").append(this.name()).append("')");
        }
        Set<Id> properties = this.properties();
        if (!properties.isEmpty()) {
            builder.append(".").append("properties(");
            int size = properties.size();
            for (Id id : this.properties()) {
                pk = this.graph.propertyKey(id);
                builder.append("'").append(pk.name()).append("'");
                if (--size <= 0) continue;
                builder.append(",");
            }
            builder.append(")");
        }
        switch (this.idStrategy()) {
            case PRIMARY_KEY: {
                builder.append(".primaryKeys(");
                List<Id> pks = this.primaryKeys();
                int size = pks.size();
                for (Id id : pks) {
                    PropertyKey pk2 = this.graph.propertyKey(id);
                    builder.append("'").append(pk2.name()).append("'");
                    if (--size <= 0) continue;
                    builder.append(",");
                }
                builder.append(")");
                break;
            }
            case CUSTOMIZE_STRING: {
                builder.append(".useCustomizeStringId()");
                break;
            }
            case CUSTOMIZE_NUMBER: {
                builder.append(".useCustomizeNumberId()");
                break;
            }
            case CUSTOMIZE_UUID: {
                builder.append(".useCustomizeUuidId()");
                break;
            }
            case AUTOMATIC: {
                builder.append(".useAutomaticId()");
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Invalid id strategy '%s'", this.idStrategy()));
            }
        }
        properties = this.nullableKeys();
        if (!properties.isEmpty()) {
            builder.append(".").append("nullableKeys(");
            int size = properties.size();
            for (Id id : properties) {
                pk = this.graph.propertyKey(id);
                builder.append("'").append(pk.name()).append("'");
                if (--size <= 0) continue;
                builder.append(",");
            }
            builder.append(")");
        }
        if (this.ttl() != 0L) {
            builder.append(".ttl(").append(this.ttl()).append(")");
            if (this.ttlStartTime() != null && !this.ttlStartTime().equals(SchemaLabel.NONE_ID)) {
                PropertyKey pk3 = this.graph.propertyKey(this.ttlStartTime());
                builder.append(".ttlStartTime('").append(pk3.name()).append("')");
            }
        }
        if (this.enableLabelIndex()) {
            builder.append(".enableLabelIndex(true)");
        } else {
            builder.append(".enableLabelIndex(false)");
        }
        Map<String, Object> userdata = this.userdata();
        if (userdata.isEmpty()) {
            return builder.toString();
        }
        for (Map.Entry<String, Object> entry : userdata.entrySet()) {
            if (GraphUtils.isHidden(entry.getKey())) continue;
            builder.append(".userdata('").append(entry.getKey()).append("',").append(entry.getValue()).append(")");
        }
        builder.append(".ifNotExist().create();");
        return builder.toString();
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("properties", this.properties());
        map.put("nullableKeys", this.nullableKeys());
        map.put("indexLabels", this.indexLabels());
        map.put("enableLabelIndex", this.enableLabelIndex());
        map.put("ttl", String.valueOf(this.ttl()));
        map.put("ttlStartTime", this.ttlStartTime().asString());
        map.put("idStrategy", this.idStrategy().string());
        map.put("primaryKeys", this.primaryKeys());
        return super.asMap(map);
    }

    public boolean generalVl() {
        return this.name() == GENERAL_VL;
    }

    public static VertexLabel fromMap(Map<String, Object> map, HugeGraphSupplier graph) {
        Id id = IdGenerator.of(((Integer)map.get("id")).intValue());
        String name = (String)map.get("name");
        VertexLabel vertexLabel = new VertexLabel(graph, id, name);
        block27: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "name": {
                    continue block27;
                }
                case "status": {
                    vertexLabel.status(SchemaStatus.valueOf(((String)entry.getValue()).toUpperCase()));
                    continue block27;
                }
                case "userdata": {
                    vertexLabel.userdata(new Userdata((Map)entry.getValue()));
                    continue block27;
                }
                case "properties": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    vertexLabel.properties(ids);
                    continue block27;
                }
                case "nullableKeys": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    vertexLabel.nullableKeys(ids);
                    continue block27;
                }
                case "indexLabels": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    vertexLabel.addIndexLabels(ids.toArray(new Id[0]));
                    continue block27;
                }
                case "enableLabelIndex": {
                    boolean enableLabelIndex = (Boolean)entry.getValue();
                    vertexLabel.enableLabelIndex(enableLabelIndex);
                    continue block27;
                }
                case "ttl": {
                    long ttl = Long.parseLong((String)entry.getValue());
                    vertexLabel.ttl(ttl);
                    continue block27;
                }
                case "ttlStartTime": {
                    long ttlStartTime = Long.parseLong((String)entry.getValue());
                    vertexLabel.ttlStartTime(IdGenerator.of(ttlStartTime));
                    continue block27;
                }
                case "idStrategy": {
                    IdStrategy idStrategy = IdStrategy.valueOf(((String)entry.getValue()).toUpperCase());
                    vertexLabel.idStrategy(idStrategy);
                    continue block27;
                }
                case "primaryKeys": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    vertexLabel.primaryKeys(ids.toArray(new Id[0]));
                    continue block27;
                }
            }
            throw new AssertionError((Object)String.format("Invalid key '%s' for vertex label", entry.getKey()));
        }
        return vertexLabel;
    }

    public static final class P {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String STATUS = "status";
        public static final String USERDATA = "userdata";
        public static final String PROPERTIES = "properties";
        public static final String NULLABLE_KEYS = "nullableKeys";
        public static final String INDEX_LABELS = "indexLabels";
        public static final String ENABLE_LABEL_INDEX = "enableLabelIndex";
        public static final String TTL = "ttl";
        public static final String TT_START_TIME = "ttlStartTime";
        public static final String ID_STRATEGY = "idStrategy";
        public static final String PRIMARY_KEYS = "primaryKeys";
    }

    public static interface Builder
    extends SchemaBuilder<VertexLabel> {
        public Id rebuildIndex();

        public Builder idStrategy(IdStrategy var1);

        public Builder useAutomaticId();

        public Builder usePrimaryKeyId();

        public Builder useCustomizeStringId();

        public Builder useCustomizeNumberId();

        public Builder useCustomizeUuidId();

        public Builder properties(String ... var1);

        public Builder primaryKeys(String ... var1);

        public Builder nullableKeys(String ... var1);

        public Builder ttl(long var1);

        public Builder ttlStartTime(String var1);

        public Builder enableLabelIndex(boolean var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);
    }
}

