/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import com.alipay.sofa.rpc.common.utils.ReflectUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BeanUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void setProperty(Object bean, String name, Class<T> clazz, T value) throws Exception {
        Method method = ReflectUtils.getPropertySetterMethod(bean.getClass(), name, clazz);
        if (method.isAccessible()) {
            method.invoke(bean, value);
        } else {
            try {
                method.setAccessible(true);
                method.invoke(bean, value);
            }
            finally {
                method.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getProperty(Object bean, String name, Class<T> clazz) throws Exception {
        Method method = ReflectUtils.getPropertyGetterMethod(bean.getClass(), name);
        if (method.isAccessible()) {
            return (T)method.invoke(bean, new Object[0]);
        }
        try {
            method.setAccessible(true);
            Object object = method.invoke(bean, new Object[0]);
            return (T)object;
        }
        finally {
            method.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyPropertiesToMap(Object bean, String prefix, Map<String, Object> map) {
        Field[] fields;
        Method[] methods;
        Class<?> clazz = bean.getClass();
        for (Method method : methods = bean.getClass().getMethods()) {
            Object val;
            Class<?> returnc = method.getReturnType();
            if (!ReflectUtils.isBeanPropertyReadMethod(method)) continue;
            String propertyName = ReflectUtils.getPropertyNameFromBeanReadMethod(method);
            try {
                if (ReflectUtils.getPropertySetterMethod(clazz, propertyName, returnc) == null) {
                }
            }
            catch (Exception e) {}
            continue;
            try {
                val = method.invoke(bean, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new SofaRpcRuntimeException("Can't access copy " + propertyName, e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new SofaRpcRuntimeException("Can't access copy " + propertyName, e);
            }
            if (val == null) continue;
            map.put(prefix + propertyName, val);
        }
        for (Field field : fields = bean.getClass().getFields()) {
            Object val;
            String fieldName;
            block14: {
                int m;
                fieldName = field.getName();
                if (map.containsKey(prefix + fieldName) || Modifier.isStatic(m = field.getModifiers()) || Modifier.isTransient(m)) continue;
                val = null;
                try {
                    if (field.isAccessible()) {
                        val = field.get(bean);
                        break block14;
                    }
                    try {
                        field.setAccessible(true);
                        val = field.get(bean);
                    }
                    finally {
                        field.setAccessible(false);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (val == null) continue;
            map.put(prefix + fieldName, val);
        }
    }

    public static void copyProperties(Object src, Object dst, String ... ignoreFields) {
        Class<?> srcClazz = src.getClass();
        Class<?> distClazz = dst.getClass();
        Method[] methods = distClazz.getMethods();
        List<String> ignoreFiledList = Arrays.asList(ignoreFields);
        for (Method dstMethod : methods) {
            String propertyName;
            if (Modifier.isStatic(dstMethod.getModifiers()) || !ReflectUtils.isBeanPropertyReadMethod(dstMethod) || ignoreFiledList.contains(propertyName = ReflectUtils.getPropertyNameFromBeanReadMethod(dstMethod))) continue;
            Class<?> dstReturnType = dstMethod.getReturnType();
            try {
                Object val;
                Method srcGetterMethod;
                Class<?> srcReturnType;
                Method dstSetterMethod = ReflectUtils.getPropertySetterMethod(distClazz, propertyName, dstReturnType);
                if (dstSetterMethod == null || !(srcReturnType = (srcGetterMethod = ReflectUtils.getPropertyGetterMethod(srcClazz, propertyName)).getReturnType()).equals(dstReturnType) || (val = srcGetterMethod.invoke(src, new Object[0])) == null) continue;
                dstSetterMethod.invoke(dst, val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> List<String> getModifiedFields(T src, T dst, String ... ignoreFields) {
        Class<?> clazz = src.getClass();
        Method[] methods = clazz.getMethods();
        List<String> ignoreFiledList = Arrays.asList(ignoreFields);
        ArrayList<String> modifiedFields = new ArrayList<String>();
        for (Method getterMethod : methods) {
            String propertyName;
            if (Modifier.isStatic(getterMethod.getModifiers()) || !ReflectUtils.isBeanPropertyReadMethod(getterMethod) || ignoreFiledList.contains(propertyName = ReflectUtils.getPropertyNameFromBeanReadMethod(getterMethod))) continue;
            Class<?> returnType = getterMethod.getReturnType();
            try {
                Method setterMethod = ReflectUtils.getPropertySetterMethod(clazz, propertyName, returnType);
                if (setterMethod == null) continue;
                Object srcVal = getterMethod.invoke(src, new Object[0]);
                Object dstVal = getterMethod.invoke(dst, new Object[0]);
                if (srcVal == null) {
                    if (dstVal == null) continue;
                    modifiedFields.add(propertyName);
                    continue;
                }
                if (dstVal == null) {
                    modifiedFields.add(propertyName);
                    continue;
                }
                if (srcVal.equals(dstVal)) continue;
                modifiedFields.add(propertyName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return modifiedFields;
    }
}

