/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.cypher;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.cypher.CypherClient;
import org.apache.hugegraph.api.cypher.CypherManager;
import org.apache.hugegraph.api.cypher.CypherModel;
import org.apache.hugegraph.api.filter.CompressInterceptor;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs/{graph}/cypher")
@Singleton
@Tag(name="CypherAPI")
public class CypherAPI
extends API {
    private static final Logger LOG = Log.logger(CypherAPI.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final String CLIENT_CONF = "conf/remote-objects.yaml";
    private final Base64.Decoder decoder = Base64.getUrlDecoder();
    private final String basic = "Basic ";
    private final String bearer = "Bearer ";
    private CypherManager cypherManager;

    private CypherManager cypherManager() {
        if (this.cypherManager == null) {
            this.cypherManager = CypherManager.configOf(CLIENT_CONF);
        }
        return this.cypherManager;
    }

    @GET
    @Timed
    @CompressInterceptor.Compress(buffer=40960)
    @Produces(value={"application/json;charset=UTF-8"})
    public CypherModel query(@Context HttpHeaders headers, @PathParam(value="graphspace") String graphspace, @PathParam(value="graph") String graph, @QueryParam(value="cypher") String cypher) {
        return this.queryByCypher(headers, graphspace, graph, cypher);
    }

    @POST
    @Timed
    @CompressInterceptor.Compress
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public CypherModel post(@Context HttpHeaders headers, @PathParam(value="graphspace") String graphspace, @PathParam(value="graph") String graph, String cypher) {
        return this.queryByCypher(headers, graphspace, graph, cypher);
    }

    private CypherModel queryByCypher(HttpHeaders headers, String graphspace, String graph, String cypher) {
        E.checkArgument((graphspace != null && !graphspace.isEmpty() ? 1 : 0) != 0, (String)"The graphspace parameter can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((graph != null && !graph.isEmpty() ? 1 : 0) != 0, (String)"The graph parameter can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((cypher != null && !cypher.isEmpty() ? 1 : 0) != 0, (String)"The cypher parameter can't be null or empty", (Object[])new Object[0]);
        String graphInfo = graphspace + "-" + graph;
        HashMap<String, String> aliases = new HashMap<String, String>(2, 1.0f);
        aliases.put("graph", graphInfo);
        aliases.put("g", "__g_" + graphInfo);
        return this.client(headers).submitQuery(cypher, aliases);
    }

    private CypherClient client(HttpHeaders headers) {
        String auth = headers.getHeaderString("Authorization");
        if (auth != null && !auth.isEmpty()) {
            auth = auth.split(",")[0];
        }
        if (auth != null) {
            if (auth.startsWith("Basic ")) {
                return this.clientViaBasic(auth);
            }
            if (auth.startsWith("Bearer ")) {
                return this.clientViaToken(auth);
            }
        }
        throw new NotAuthorizedException((Object)"The Cypher-API called without any authorization.", new Object[0]);
    }

    private CypherClient clientViaBasic(String auth) {
        Pair<String, String> userPass = this.toUserPass(auth);
        E.checkNotNull(userPass, (String)"user-password-pair");
        return this.cypherManager().getClient((String)userPass.getLeft(), (String)userPass.getRight());
    }

    private CypherClient clientViaToken(String auth) {
        return this.cypherManager().getClient(auth.substring("Bearer ".length()));
    }

    private Pair<String, String> toUserPass(String auth) {
        String[] split;
        if (auth == null || auth.isEmpty()) {
            return null;
        }
        if (!auth.startsWith("Basic ")) {
            return null;
        }
        try {
            String encoded = auth.substring("Basic ".length());
            byte[] userPass = this.decoder.decode(encoded);
            String authorization = new String(userPass, UTF8);
            split = authorization.split(":");
        }
        catch (Exception e) {
            LOG.error("Failed convert auth to credential.", (Throwable)e);
            return null;
        }
        if (split.length != 2) {
            return null;
        }
        return ImmutablePair.of((Object)split[0], (Object)split[1]);
    }
}

