/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.lang.reflect.Field;
import org.apache.hugegraph.annotation.MergeProperty;
import org.apache.hugegraph.common.Mergeable;
import org.apache.hugegraph.exception.InternalException;

public final class EntityUtil {
    public static <T extends Mergeable> T merge(T oldEntity, T newEntity) {
        Field[] fields;
        Mergeable entity;
        Class<?> clazz = oldEntity.getClass();
        try {
            entity = (Mergeable)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InternalException("reflect.new-instance.failed", (Throwable)e, clazz.getName());
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            MergeProperty property;
            if (field.getName().startsWith("$") || (property = field.getAnnotation(MergeProperty.class)) == null) continue;
            field.setAccessible(true);
            try {
                Object oldFieldValue = field.get(oldEntity);
                Object newFieldValue = field.get(newEntity);
                if (property.useNew()) {
                    if (property.ignoreNull() && newFieldValue == null) {
                        field.set(entity, oldFieldValue);
                        continue;
                    }
                    field.set(entity, newFieldValue);
                    continue;
                }
                field.set(entity, oldFieldValue);
            }
            catch (IllegalAccessException e) {
                throw new InternalException("reflect.access-field.failed", (Throwable)e, field.getName(), clazz.getName());
            }
        }
        return (T)entity;
    }
}

