/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.PathOfVertices;

public class ShortestPathAPI
extends TraversersAPI {
    public ShortestPathAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return "shortestpath";
    }

    public PathOfVertices get(Object sourceId, Object targetId, Direction direction, String label, int maxDepth, long degree, long skipDegree, long capacity) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        String target = GraphAPI.formatVertexId(targetId, false);
        ShortestPathAPI.checkPositive(maxDepth, "Max depth of shortest path");
        ShortestPathAPI.checkDegree(degree);
        ShortestPathAPI.checkCapacity(capacity);
        ShortestPathAPI.checkSkipDegree(skipDegree, degree, capacity);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("target", target);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", maxDepth);
        params.put("max_degree", degree);
        params.put("skip_degree", skipDegree);
        params.put("capacity", capacity);
        RestResult result = this.client.get(this.path(), params);
        return (PathOfVertices)result.readObject(PathOfVertices.class);
    }
}

