/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.base.Printer;
import org.apache.hugegraph.base.ToolClient;
import org.apache.hugegraph.base.ToolManager;
import org.apache.hugegraph.cmd.SubCommands;
import org.apache.hugegraph.exception.ExitException;
import org.apache.hugegraph.manager.AuthBackupRestoreManager;
import org.apache.hugegraph.manager.BackupManager;
import org.apache.hugegraph.manager.DumpGraphManager;
import org.apache.hugegraph.manager.GraphsManager;
import org.apache.hugegraph.manager.GremlinManager;
import org.apache.hugegraph.manager.RestoreManager;
import org.apache.hugegraph.manager.TasksManager;
import org.apache.hugegraph.structure.Task;
import org.apache.hugegraph.structure.constant.GraphMode;
import org.apache.hugegraph.structure.gremlin.Result;
import org.apache.hugegraph.structure.gremlin.ResultSet;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ToolUtil;

public class HugeGraphCommand {
    private static final int DEFAULT_GRAPH_CLEAR_TIMEOUT = 300;
    private static final int DEFAULT_GRAPH_CREATE_TIMEOUT = 300;
    private SubCommands subCommands;
    private List<ToolManager> taskManagers;
    @ParametersDelegate
    private SubCommands.Url url = new SubCommands.Url();
    @ParametersDelegate
    private SubCommands.Graph graph = new SubCommands.Graph();
    @ParametersDelegate
    private SubCommands.Username username = new SubCommands.Username();
    @ParametersDelegate
    private SubCommands.Password password = new SubCommands.Password();
    @ParametersDelegate
    private SubCommands.Timeout timeout = new SubCommands.Timeout();
    @ParametersDelegate
    private SubCommands.TrustStoreFile trustStoreFile = new SubCommands.TrustStoreFile();
    @ParametersDelegate
    private SubCommands.TrustStorePassword trustStorePassword = new SubCommands.TrustStorePassword();
    @ParametersDelegate
    private SubCommands.ThrowMode throwMode = new SubCommands.ThrowMode();

    public HugeGraphCommand() {
        this.subCommands = new SubCommands();
        this.taskManagers = Lists.newArrayList();
    }

    public Map<String, Object> subCommands() {
        return this.subCommands.commands();
    }

    public <T> T subCommand(String subCmd) {
        return (T)this.subCommands.commands().get(subCmd);
    }

    public String url() {
        return this.url.url;
    }

    private void url(String url) {
        this.url.url = url;
    }

    public String graph() {
        return this.graph.graph;
    }

    private void graph(String graph) {
        this.graph.graph = graph;
    }

    public String username() {
        return this.username.username;
    }

    public void username(String username) {
        this.username.username = username;
    }

    public String password() {
        return this.password.password;
    }

    public void password(String password) {
        this.password.password = password;
    }

    public int timeout() {
        return this.timeout.timeout;
    }

    public void timeout(int timeout) {
        this.timeout.timeout = timeout;
    }

    public String trustStoreFile() {
        return this.trustStoreFile.trustStoreFile;
    }

    public void trustStoreFile(String trustStoreFile) {
        this.trustStoreFile.trustStoreFile = trustStoreFile;
    }

    public String trustStorePassword() {
        return this.trustStorePassword.trustStorePassword;
    }

    public void trustStorePassword(String trustStorePassword) {
        this.trustStorePassword.trustStorePassword = trustStorePassword;
    }

    public boolean throwMode() {
        return this.throwMode.throwMode;
    }

    private void throwMode(boolean throwMode) {
        this.throwMode.throwMode = throwMode;
    }

    public JCommander jcommander() {
        JCommander.Builder builder = JCommander.newBuilder();
        builder.addObject((Object)this);
        for (Map.Entry<String, Object> entry : this.subCommands().entrySet()) {
            builder.addCommand(entry.getKey(), entry.getValue(), new String[0]);
        }
        JCommander jCommander = builder.build();
        jCommander.setProgramName("hugegraph");
        jCommander.setCaseSensitiveOptions(true);
        jCommander.setAllowAbbreviatedOptions(true);
        return jCommander;
    }

    private void execute(String subCmd, JCommander jCommander) {
        this.checkMainParams();
        switch (subCmd) {
            case "backup": {
                if (this.timeout() < 120) {
                    this.timeout(120);
                }
                Printer.print("Graph '%s' start backup!", this.graph());
                SubCommands.Backup backup = (SubCommands.Backup)this.subCommand(subCmd);
                BackupManager backupManager = this.manager(BackupManager.class);
                backupManager.init(backup);
                backupManager.backup(backup.types());
                break;
            }
            case "restore": {
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                GraphMode mode = graphsManager.mode(this.graph());
                E.checkState((boolean)mode.maintaining(), (String)"Invalid mode '%s' of graph '%s' for restore sub-command", (Object[])new Object[]{mode, this.graph()});
                Printer.print("Graph '%s' start restore in mode '%s'!", this.graph(), mode);
                SubCommands.Restore restore = (SubCommands.Restore)this.subCommand(subCmd);
                RestoreManager restoreManager = this.manager(RestoreManager.class);
                restoreManager.init(restore);
                restoreManager.mode(mode);
                restoreManager.restore(restore.types());
                break;
            }
            case "migrate": {
                SubCommands.Migrate migrate = (SubCommands.Migrate)this.subCommand(subCmd);
                Printer.print("Migrate graph '%s' from '%s' to '%s' as '%s'", this.graph(), this.url(), migrate.targetUrl(), migrate.targetGraph());
                if (this.timeout() < 120) {
                    this.timeout(120);
                }
                SubCommands.Backup backup = HugeGraphCommand.convMigrate2Backup(migrate);
                BackupManager backupManager = this.manager(BackupManager.class);
                backupManager.init(backup);
                backupManager.backup(backup.types());
                this.url(migrate.targetUrl());
                this.graph(migrate.targetGraph());
                this.username(migrate.targetUsername());
                this.password(migrate.targetPassword());
                this.timeout(migrate.targetTimeout());
                this.trustStoreFile(migrate.targetTrustStoreFile());
                this.trustStorePassword(migrate.targetTrustStorePassword());
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                GraphMode origin = graphsManager.mode(migrate.targetGraph());
                GraphMode mode = migrate.mode();
                E.checkState((boolean)mode.maintaining(), (String)"Invalid mode '%s' of graph '%s' for restore", (Object[])new Object[]{mode, migrate.targetGraph()});
                graphsManager.mode(migrate.targetGraph(), mode);
                Printer.print("Graph '%s' start restore in mode '%s'!", migrate.targetGraph(), migrate.mode());
                String directory = backupManager.directory().directory();
                SubCommands.Restore restore = HugeGraphCommand.convMigrate2Restore(migrate, directory);
                RestoreManager restoreManager = this.manager(RestoreManager.class);
                restoreManager.init(restore);
                restoreManager.mode(mode);
                restoreManager.restore(restore.types());
                graphsManager.mode(migrate.targetGraph(), origin);
                break;
            }
            case "dump": {
                Printer.print("Graph '%s' start dump!", this.graph());
                SubCommands.DumpGraph dump = (SubCommands.DumpGraph)this.subCommand(subCmd);
                DumpGraphManager dumpManager = this.manager(DumpGraphManager.class);
                dumpManager.init(dump);
                dumpManager.dumpFormatter(dump.formatter());
                dumpManager.dump();
                break;
            }
            case "graph-create": {
                SubCommands.GraphCreate graphCreate = (SubCommands.GraphCreate)this.subCommand(subCmd);
                if (this.timeout() < 300) {
                    this.timeout(300);
                }
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                graphsManager.create(graphCreate.name(), graphCreate.config());
                Printer.print("Graph '%s' is created", graphCreate.name());
                break;
            }
            case "graph-clone": {
                SubCommands.GraphClone graphClone = (SubCommands.GraphClone)this.subCommand(subCmd);
                if (this.timeout() < 300) {
                    this.timeout(300);
                }
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                graphsManager.clone(graphClone.name(), graphClone.cloneGraphName());
                Printer.print("Graph '%s' is created(cloned from '%s')", graphClone.name(), graphClone.cloneGraphName());
                break;
            }
            case "graph-list": {
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                Printer.printList("Graphs", graphsManager.list());
                break;
            }
            case "graph-get": {
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                Printer.printMap("Graph info", graphsManager.get(this.graph()));
                break;
            }
            case "graph-clear": {
                SubCommands.GraphClear graphClear = (SubCommands.GraphClear)this.subCommand(subCmd);
                if (this.timeout() < 300) {
                    this.timeout(300);
                }
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                graphsManager.clear(this.graph(), graphClear.confirmMessage());
                Printer.print("Graph '%s' is cleared", this.graph());
                break;
            }
            case "graph-drop": {
                SubCommands.GraphDrop graphDrop = (SubCommands.GraphDrop)this.subCommand(subCmd);
                if (this.timeout() < 300) {
                    this.timeout(300);
                }
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                graphsManager.drop(this.graph(), graphDrop.confirmMessage());
                Printer.print("Graph '%s' is dropped", this.graph());
                break;
            }
            case "graph-mode-set": {
                SubCommands.GraphModeSet graphModeSet = (SubCommands.GraphModeSet)this.subCommand(subCmd);
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                graphsManager.mode(this.graph(), graphModeSet.mode());
                Printer.print("Set graph '%s' mode to '%s'", this.graph(), graphModeSet.mode());
                break;
            }
            case "graph-mode-get": {
                GraphsManager graphsManager = this.manager(GraphsManager.class);
                Printer.printKV("Graph mode", graphsManager.mode(this.graph()));
                break;
            }
            case "gremlin-execute": {
                SubCommands.Gremlin gremlin = (SubCommands.Gremlin)this.subCommand(subCmd);
                GremlinManager gremlinManager = this.manager(GremlinManager.class);
                Printer.print("Run gremlin script");
                ResultSet result = gremlinManager.execute(gremlin.script(), gremlin.bindings(), gremlin.language(), gremlin.aliases());
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    Printer.print(((Result)iterator.next()).getString());
                }
                break;
            }
            case "gremlin-schedule": {
                SubCommands.GremlinJob job = (SubCommands.GremlinJob)this.subCommand(subCmd);
                GremlinManager gremlinManager = this.manager(GremlinManager.class);
                Printer.print("Run gremlin script as async job");
                long taskId = gremlinManager.executeAsTask(job.script(), job.bindings(), job.language());
                Printer.printKV("Task id", taskId);
                break;
            }
            case "task-list": {
                SubCommands.TaskList taskList = (SubCommands.TaskList)this.subCommand(subCmd);
                TasksManager tasksManager = this.manager(TasksManager.class);
                List<Task> tasks = tasksManager.list(taskList.status(), taskList.limit());
                List results = tasks.stream().map(Task::asMap).collect(Collectors.toList());
                Printer.printList("Tasks", results);
                break;
            }
            case "task-get": {
                SubCommands.TaskGet taskGet = (SubCommands.TaskGet)this.subCommand(subCmd);
                TasksManager tasksManager = this.manager(TasksManager.class);
                Printer.printKV("Task info", tasksManager.get(taskGet.taskId()).asMap());
                break;
            }
            case "task-delete": {
                SubCommands.TaskDelete taskDelete = (SubCommands.TaskDelete)this.subCommand(subCmd);
                TasksManager tasksManager = this.manager(TasksManager.class);
                tasksManager.delete(taskDelete.taskId());
                Printer.print("Task '%s' is deleted", taskDelete.taskId());
                break;
            }
            case "task-cancel": {
                SubCommands.TaskCancel taskCancel = (SubCommands.TaskCancel)this.subCommand(subCmd);
                TasksManager tasksManager = this.manager(TasksManager.class);
                tasksManager.cancel(taskCancel.taskId());
                Printer.print("Task '%s' is cancelled", taskCancel.taskId());
                break;
            }
            case "task-clear": {
                SubCommands.TaskClear taskClear = (SubCommands.TaskClear)this.subCommand(subCmd);
                TasksManager tasksManager = this.manager(TasksManager.class);
                tasksManager.clear(taskClear.force());
                Printer.print("Tasks are cleared[force=%s]", taskClear.force());
                break;
            }
            case "auth-backup": {
                Printer.print("Auth backup start...");
                SubCommands.AuthBackup authBackup = (SubCommands.AuthBackup)this.subCommand(subCmd);
                AuthBackupRestoreManager authBackupManager = this.manager(AuthBackupRestoreManager.class);
                authBackupManager.init(authBackup);
                authBackupManager.backup(authBackup.types());
                break;
            }
            case "auth-restore": {
                Printer.print("Auth restore start...");
                SubCommands.AuthRestore authRestore = (SubCommands.AuthRestore)this.subCommand(subCmd);
                AuthBackupRestoreManager authRestoreManager = this.manager(AuthBackupRestoreManager.class);
                authRestoreManager.init(authRestore);
                authRestoreManager.restore(authRestore.types());
                break;
            }
            default: {
                throw new ParameterException(String.format("Invalid sub-command: %s", subCmd));
            }
        }
    }

    private void execute(String[] args) {
        JCommander jCommander = this.parseCommand(args);
        this.execute(jCommander.getParsedCommand(), jCommander);
    }

    private void checkMainParams() {
        E.checkArgument((this.url() != null ? 1 : 0) != 0, (String)"Url can't be null", (Object[])new Object[0]);
        E.checkArgument((this.username() == null && this.password() == null || this.username() != null && this.password() != null ? 1 : 0) != 0, (String)"Both user name and password must be null or not null at same time", (Object[])new Object[0]);
    }

    private <T extends ToolManager> T manager(Class<T> clz) {
        try {
            ToolClient.ConnectionInfo info = new ToolClient.ConnectionInfo(this.url(), this.graph(), this.username(), this.password(), this.timeout(), this.trustStoreFile(), this.trustStorePassword());
            ToolManager toolManager = (ToolManager)clz.getConstructor(ToolClient.ConnectionInfo.class).newInstance(info);
            this.taskManagers.add(toolManager);
            return (T)toolManager;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Construct manager failed for class '%s', please make sure global arguments set correctly: --url=%s,--graph=%s,--user=%s,--password=%s,--timeout=%s,--trust-store-file=%s,--trust-store-password=%s", clz.getSimpleName(), this.url(), this.graph(), this.username(), this.password(), this.timeout(), this.trustStoreFile(), this.trustStorePassword()), e);
        }
    }

    private static SubCommands.Backup convMigrate2Backup(SubCommands.Migrate migrate) {
        SubCommands.Backup backup = new SubCommands.Backup();
        backup.splitSize(migrate.splitSize());
        backup.directory(migrate.directory());
        backup.logDir(migrate.logDir());
        backup.types(migrate.types());
        backup.retry(migrate.retry());
        backup.hdfsConf(migrate.hdfsConf());
        return backup;
    }

    private static SubCommands.Restore convMigrate2Restore(SubCommands.Migrate migrate, String directory) {
        SubCommands.Restore restore = new SubCommands.Restore();
        restore.clean(!migrate.keepData());
        restore.directory(directory);
        restore.logDir(migrate.logDir());
        restore.types(migrate.types());
        restore.retry(migrate.retry());
        restore.hdfsConf(migrate.hdfsConf());
        return restore;
    }

    private GraphMode mode() {
        GraphsManager graphsManager = this.manager(GraphsManager.class);
        GraphMode mode = graphsManager.mode(this.graph());
        E.checkState((boolean)mode.maintaining(), (String)"Invalid mode '%s' of graph '%s' for restore sub-command", (Object[])new Object[]{mode, this.graph()});
        return mode;
    }

    public JCommander parseCommand(String[] args) {
        String subCommand;
        JCommander jCommander = this.jcommander();
        if (args.length == 0) {
            throw ExitException.exception(ToolUtil.commandUsage(jCommander), "No command found, please input command", new Object[0]);
        }
        if (this.parseHelp(args, jCommander)) {
            assert (false);
        } else {
            jCommander.parse(args);
        }
        if ((subCommand = jCommander.getParsedCommand()) == null) {
            throw ExitException.normal(ToolUtil.commandsCategory(jCommander), "No sub-command found", new Object[0]);
        }
        return jCommander;
    }

    public boolean parseHelp(String[] args, JCommander jCommander) {
        int index;
        String subCommand = "";
        List<String> list = Arrays.asList(args);
        if (!list.contains("help")) {
            return false;
        }
        if (list.contains("--throw-mode")) {
            index = list.indexOf("--throw-mode") + 1;
            jCommander.parse(new String[]{"--throw-mode", list.get(index)});
        }
        index = list.indexOf("help");
        if (list.size() > index + 1) {
            subCommand = list.get(index + 1);
        }
        if (StringUtils.isEmpty((CharSequence)subCommand)) {
            throw ExitException.normal(ToolUtil.commandUsage(jCommander), "Command : hugegragh help", new Object[0]);
        }
        Map commands = jCommander.getCommands();
        if (commands.containsKey(subCommand)) {
            throw ExitException.normal(ToolUtil.commandUsage((JCommander)commands.get(subCommand)), "Command : hugegragh help %s", subCommand);
        }
        throw ExitException.exception(ToolUtil.commandsCategory(jCommander), "Unexpected help sub-command %s", subCommand);
    }

    public void shutdown() {
        if (CollectionUtils.isEmpty(this.taskManagers)) {
            return;
        }
        for (ToolManager toolManager : this.taskManagers) {
            toolManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HugeGraphCommand cmd = new HugeGraphCommand();
        int exitCode = 0;
        try {
            cmd.execute(args);
        }
        catch (ExitException e) {
            exitCode = e.exitCode();
            ToolUtil.exitOrThrow(e, cmd.throwMode());
        }
        catch (Throwable e) {
            exitCode = -1;
            ToolUtil.printOrThrow(e, cmd.throwMode());
        }
        finally {
            cmd.shutdown();
        }
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }
}

