/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.jcodings.ApplyAllCaseFoldFunction;
import org.apache.hadoop.hbase.shaded.org.jcodings.Encoding;
import org.apache.hadoop.hbase.shaded.org.joni.ApplyCaseFoldArg;
import org.apache.hadoop.hbase.shaded.org.joni.BitSet;
import org.apache.hadoop.hbase.shaded.org.joni.ScanEnvironment;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CClassNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.ConsAltNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.StringNode;

final class ApplyCaseFold
implements ApplyAllCaseFoldFunction {
    static final ApplyCaseFold INSTANCE = new ApplyCaseFold();

    ApplyCaseFold() {
    }

    public void apply(int from, int[] to, int length, Object o) {
        ApplyCaseFoldArg arg = (ApplyCaseFoldArg)o;
        ScanEnvironment env = arg.env;
        Encoding enc = env.enc;
        CClassNode cc = arg.cc;
        BitSet bs = cc.bs;
        if (length == 1) {
            boolean inCC = cc.isCodeInCC(enc, from);
            if (inCC && !cc.isNot() || !inCC && cc.isNot()) {
                if (enc.minLength() > 1 || to[0] >= 256) {
                    cc.addCodeRange(env, to[0], to[0]);
                } else {
                    bs.set(to[0]);
                }
            }
        } else if (cc.isCodeInCC(enc, from) && !cc.isNot()) {
            StringNode node = null;
            for (int i = 0; i < length; ++i) {
                if (i == 0) {
                    node = new StringNode();
                    node.setAmbig();
                }
                node.catCode(to[i], enc);
            }
            ConsAltNode alt = ConsAltNode.newAltNode(node, null);
            if (arg.tail == null) {
                arg.altRoot = alt;
            } else {
                arg.tail.setCdr(alt);
            }
            arg.tail = alt;
        }
    }
}

