/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.filter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.loader.filter.ElementParser;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;

public class ElementLimitFilter
implements ElementParser {
    private static final int LRU_CAPACITY = 100000;
    private final long limit;
    private Map<Object, AtomicLong> records;
    private LruCounter<Object> counter;

    public ElementLimitFilter(long limit) {
        this.limit = limit;
        this.records = new ConcurrentHashMap<Object, AtomicLong>();
        this.counter = new LruCounter(100000, true);
    }

    @Override
    public boolean parse(GraphElement element) {
        if (element instanceof Vertex) {
            return true;
        }
        Edge edge = (Edge)element;
        this.records.computeIfAbsent(edge.sourceId(), k -> new AtomicLong(1L));
        AtomicLong count = this.records.computeIfPresent(edge.sourceId(), (k, v) -> {
            v.addAndGet(1L);
            return v;
        });
        return this.counter.addAndGet(edge.sourceId()) <= this.limit && this.counter.addAndGet(edge.targetId()) <= this.limit;
    }

    class LruCounter<K> {
        private Map<K, AtomicLong> map;
        private Queue<K> lastUsedQueue;
        private final int capacity;

        public LruCounter(int capacity, boolean concurrent) {
            this.capacity = capacity;
            if (concurrent) {
                this.map = new ConcurrentHashMap<K, AtomicLong>(capacity);
                this.lastUsedQueue = new ConcurrentLinkedQueue<K>();
            } else {
                this.map = new HashMap<K, AtomicLong>();
                this.lastUsedQueue = new LinkedList<K>();
            }
        }

        long addAndGet(K key) {
            Number value = this.map.get(key);
            if (value == null) {
                value = this.putNewValue(key);
            }
            this.refreshKey(key);
            return value.longValue();
        }

        private synchronized void refreshKey(K key) {
            this.lastUsedQueue.remove(key);
            this.lastUsedQueue.add(key);
        }

        private synchronized AtomicLong putNewValue(K key) {
            if (!this.map.containsKey(key)) {
                if (this.map.size() >= this.capacity) {
                    K keyToRemove = this.lastUsedQueue.poll();
                    this.map.remove(keyToRemove);
                }
                AtomicLong value = new AtomicLong(1L);
                this.map.put(key, value);
                this.lastUsedQueue.add(key);
                return value;
            }
            return this.map.get(key);
        }
    }
}

