/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.kafka.server.ActionQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedActionQueue
implements ActionQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedActionQueue.class);
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();

    @Override
    public void add(Runnable action) {
        this.queue.add(action);
    }

    @Override
    public void tryCompleteActions() {
        int maxToComplete = this.queue.size();
        for (int count = 0; count < maxToComplete; ++count) {
            try {
                Runnable action = this.queue.poll();
                if (action == null) {
                    return;
                }
                action.run();
                continue;
            }
            catch (Throwable e) {
                LOGGER.error("failed to complete delayed actions", e);
            }
        }
    }
}

