/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.server.DelayedDeleteRecordsMetrics$;
import kafka.server.DeleteRecordsPartitionStatus;
import kafka.server.HostedPartition;
import kafka.server.HostedPartition$None$;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.purgatory.DelayedOperation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}3A!\u0003\u0006\u0001\u001f!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u000bA\u0003A\u0011A)\t\u000b]\u0003A\u0011\t-\t\u000bq\u0003A\u0011I/\t\u000by\u0003A\u0011I/\u0003)\u0011+G.Y=fI\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t\u0015\tYA\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u00119A\u0011\u0011CG\u0007\u0002%)\u00111\u0003F\u0001\naV\u0014x-\u0019;pefT!aC\u000b\u000b\u000551\"BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001eL!a\u0007\n\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0007CA\u000f!\u001b\u0005q\"BA\u0010\r\u0003\u0015)H/\u001b7t\u0013\t\tcDA\u0004M_\u001e<\u0017N\\4\u0002\u000f\u0011,G.Y=NgB\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t!Aj\u001c8h\u0003M!W\r\\3uKJ+7m\u001c:egN#\u0018\r^;t!\u0011Yc\u0006\r\u001c\u000e\u00031R!!L\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00020Y\t\u0019Q*\u00199\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005M*\u0012AB2p[6|g.\u0003\u00026e\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CA\u001c9\u001b\u0005Q\u0011BA\u001d\u000b\u0005q!U\r\\3uKJ+7m\u001c:egB\u000b'\u000f^5uS>t7\u000b^1ukN\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u00028y%\u0011QH\u0003\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003%\u0001\nk\u0015BA!&\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003,]A\u001a\u0005C\u0001#K\u001d\t)\u0005*D\u0001G\u0015\t9%'A\u0004nKN\u001c\u0018mZ3\n\u0005%3\u0015!\u0007#fY\u0016$XMU3d_J$7OU3ta>t7/\u001a#bi\u0006L!a\u0013'\u00039\u0011+G.\u001a;f%\u0016\u001cwN\u001d3t!\u0006\u0014H/\u001b;j_:\u0014Vm];mi*\u0011\u0011J\u0012\t\u0003I9K!aT\u0013\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bI\u001bF+\u0016,\u0011\u0005]\u0002\u0001\"\u0002\u0012\u0006\u0001\u0004\u0019\u0003\"B\u0015\u0006\u0001\u0004Q\u0003\"\u0002\u001e\u0006\u0001\u0004Y\u0004\"\u0002 \u0006\u0001\u0004y\u0014a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\u0012!\u0017\t\u0003IiK!aW\u0013\u0003\u000f\t{w\u000e\\3b]\u0006aqN\\#ya&\u0014\u0018\r^5p]R\tQ*\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016\u0004")
public class DelayedDeleteRecords
extends DelayedOperation
implements Logging {
    private final Map<TopicPartition, DeleteRecordsPartitionStatus> deleteRecordsStatus;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, DeleteRecordsResponseData.DeleteRecordsPartitionResult>, BoxedUnit> responseCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean tryComplete() {
        this.deleteRecordsStatus.foreachEntry((Function2 & Serializable)(topicPartition, status) -> {
            void var8_9;
            long l;
            Errors errors;
            boolean bl;
            this.trace((Function0<String>)(Function0 & Serializable)() -> "Checking delete records satisfaction for " + topicPartition + ", current status " + status);
            if (!status.acksPending()) return BoxedUnit.UNIT;
            HostedPartition hostedPartition = $this.replicaManager.getPartition((TopicPartition)topicPartition);
            if (hostedPartition instanceof HostedPartition.Online) {
                Partition partition = ((HostedPartition.Online)hostedPartition).partition();
                Option<UnifiedLog> option = partition.leaderLogIfLocal();
                if (option instanceof Some) {
                    long leaderLW = partition.lowWatermarkIfLeader();
                    bl = leaderLW >= status.requiredOffset();
                    errors = Errors.NONE;
                    l = leaderLW;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    bl = false;
                    errors = Errors.NOT_LEADER_OR_FOLLOWER;
                    l = -1L;
                }
            } else if (hostedPartition instanceof HostedPartition.Offline) {
                bl = false;
                errors = Errors.KAFKA_STORAGE_ERROR;
                l = -1L;
            } else {
                if (!HostedPartition$None$.MODULE$.equals(hostedPartition)) throw new MatchError((Object)hostedPartition);
                bl = false;
                errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                l = -1L;
            }
            long l2 = l;
            Errors errors2 = errors;
            boolean lowWatermarkReached = bl;
            Errors errors3 = errors2;
            Errors errors4 = Errors.NONE;
            if (!(errors3 != null ? !errors3.equals(errors4) : errors4 != null) && var8_9 == false) return BoxedUnit.UNIT;
            status.acksPending_$eq(false);
            status.responseStatus().setErrorCode(errors2.code());
            return status.responseStatus().setLowWatermark(l2);
        });
        if (!this.deleteRecordsStatus.values().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.acksPending()))) {
            return this.forceComplete();
        }
        return false;
    }

    public void onExpiration() {
        this.deleteRecordsStatus.foreachEntry((Function2 & Serializable)(topicPartition, status) -> {
            DelayedDeleteRecords.$anonfun$onExpiration$1(topicPartition, status);
            return BoxedUnit.UNIT;
        });
    }

    public void onComplete() {
        Map responseStatus = (Map)this.deleteRecordsStatus.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition k = (TopicPartition)x0$1._1();
                DeleteRecordsPartitionStatus status = (DeleteRecordsPartitionStatus)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)status.responseStatus());
            }
            throw new MatchError(null);
        });
        this.responseCallback.apply((Object)responseStatus);
    }

    public static final /* synthetic */ void $anonfun$new$1(DelayedDeleteRecords $this, TopicPartition topicPartition, DeleteRecordsPartitionStatus status) {
        if (status.responseStatus().errorCode() == Errors.NONE.code()) {
            status.acksPending_$eq(true);
            status.responseStatus().setErrorCode(Errors.REQUEST_TIMED_OUT.code());
        } else {
            status.acksPending_$eq(false);
        }
        $this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Initial partition status for %s is %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, status})));
    }

    public static final /* synthetic */ void $anonfun$onExpiration$1(TopicPartition topicPartition, DeleteRecordsPartitionStatus status) {
        if (status.acksPending()) {
            DelayedDeleteRecordsMetrics$.MODULE$.recordExpiration(topicPartition);
            return;
        }
    }

    public DelayedDeleteRecords(long delayMs, Map<TopicPartition, DeleteRecordsPartitionStatus> deleteRecordsStatus, ReplicaManager replicaManager, Function1<Map<TopicPartition, DeleteRecordsResponseData.DeleteRecordsPartitionResult>, BoxedUnit> responseCallback) {
        this.deleteRecordsStatus = deleteRecordsStatus;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs);
        deleteRecordsStatus.foreachEntry((Function2 & Serializable)(topicPartition, status) -> {
            DelayedDeleteRecords.$anonfun$new$1(this, topicPartition, status);
            return BoxedUnit.UNIT;
        });
    }
}

