/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.DynamicTopicClusterQuotaPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t%s!B\u0013'\u0011\u0003ic!B\u0018'\u0011\u0003\u0001\u0004\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001e\u0001B\u0018'\u0001\u0019D\u0001\"\u001e\u0003\u0003\u0002\u0003\u0006IA\u001e\u0005\tu\u0012\u0011\t\u0011)A\u0005w\"Aa\u0010\u0002B\u0001B\u0003%q\u0010\u0003\u0006\u0002\f\u0011\u0011\t\u0011)A\u0005\u0003\u001bA!\"a\u0005\u0005\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\t)\u0003\u0002B\u0001B\u0003%\u0011q\u0005\u0005\u000b\u0003k!!\u0011!Q\u0001\n\u0005]\u0002BCA#\t\t\u0005\r\u0011\"\u0001\u0002H!Q\u0011q\n\u0003\u0003\u0002\u0004%\t!!\u0015\t\u0015\u0005uCA!A!B\u0013\tI\u0005\u0003\u0006\u0002`\u0011\u0011\t\u0011)A\u0005\u0003CB!\"a\u001a\u0005\u0005\u0003\u0005\u000b\u0011BA5\u0011)\ty\u0007\u0002B\u0001B\u0003%\u0011\u0011\u000f\u0005\u000b\u0003o\"!\u0011!Q\u0001\n\u0005e\u0004BCA@\t\t\u0005\t\u0015!\u0003\u0002\u0002\"Q\u0011q\u0011\u0003\u0003\u0002\u0003\u0006I!!#\t\u0015\u0005]EA!A!\u0002\u0013\tI\t\u0003\u0004>\t\u0011\u0005\u0011\u0011\u0014\u0005\n\u0003w#!\u0019!C\u0001\u0003{C\u0001\"!2\u0005A\u0003%\u0011q\u0018\u0005\n\u0003\u000f$\u0001\u0019!C\u0001\u0003\u0013D\u0011\"!5\u0005\u0001\u0004%\t!a5\t\u0011\u0005]G\u0001)Q\u0005\u0003\u0017D\u0011\"!7\u0005\u0005\u0004%\t!a7\t\u0011\u0005MH\u0001)A\u0005\u0003;Dq!!>\u0005\t\u0003\n9\u0010C\u0004\u0002z\u0012!\t%a?\t\u000f\tEA\u0001\"\u0003\u0003\u0014!9!1\u0005\u0003\u0005\u0002\t\u0015\u0002b\u0002B\u001f\t\u0011%!q\b\u0005\b\u0005\u0007\"A\u0011\u0002B#\u0011\u001d\u00119\u0005\u0002C!\u0005\u000b\nqC\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u000b\u0005\u001dB\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u0005%R\u0013AB:feZ,'OC\u0001,\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AL\u0001\u000e\u0003\u0019\u0012qC\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0014\u0007\u0005\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003qmj\u0011!\u000f\u0006\u0003u)\nQ!\u001e;jYNL!\u0001P\u001d\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!L\u0001\u000eO\u0016$Hk\u001c9jG\u0012+G\u000e^1\u0015\t\u0005{E,\u0019\t\u0004e\t#\u0015BA\"4\u0005\u0019y\u0005\u000f^5p]B\u0011Q)T\u0007\u0002\r*\u0011q\tS\u0001\u0006S6\fw-\u001a\u0006\u0003W%S!AS&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0015aA8sO&\u0011aJ\u0012\u0002\u000b)>\u0004\u0018n\u0019#fYR\f\u0007\"\u0002)\u0004\u0001\u0004\t\u0016!\u0003;pa&\u001cg*Y7f!\t\u0011\u0016L\u0004\u0002T/B\u0011AkM\u0007\u0002+*\u0011a\u000bL\u0001\u0007yI|w\u000e\u001e \n\u0005a\u001b\u0014A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001W\u001a\t\u000bu\u001b\u0001\u0019\u00010\u0002\u00119,w/S7bO\u0016\u0004\"!R0\n\u0005\u00014%!D'fi\u0006$\u0017\r^1J[\u0006<W\rC\u0003c\u0007\u0001\u00071-A\u0003eK2$\u0018\r\u0005\u0002FI&\u0011QM\u0012\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1\u0014\t\u00119wn\u000e\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA\u0001\\1oO*\tA.\u0001\u0003kCZ\f\u0017B\u00018j\u0005\u0019y%M[3diB\u0011\u0001o]\u0007\u0002c*\u0011!OR\u0001\naV\u0014G.[:iKJL!\u0001^9\u0003#5+G/\u00193bi\u0006\u0004VO\u00197jg\",'/\u0001\u0004d_:4\u0017n\u001a\t\u0003obl\u0011\u0001K\u0005\u0003s\"\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\"A\f?\n\u0005u4#AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016\f!\u0002\\8h\u001b\u0006t\u0017mZ3s!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003U\u0005\u0019An\\4\n\t\u0005%\u00111\u0001\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0004o\u0006=\u0011bAA\tQ\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\tQa\u001a:pkBT1!a\bI\u0003-\u0019wn\u001c:eS:\fGo\u001c:\n\t\u0005\r\u0012\u0011\u0004\u0002\u0011\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\fa\u0002\u001e=o\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0003\u0002*\u0005ERBAA\u0016\u0015\u0011\ti#a\f\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0004\u0003?Q\u0013\u0002BA\u001a\u0003W\u0011a\u0003\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u0001\u0011g\"\f'/Z\"p_J$\u0017N\\1u_J\u0004BA\r\"\u0002:A!\u00111HA!\u001b\t\tiD\u0003\u0003\u0002@\u0005u\u0011!B:iCJ,\u0017\u0002BA\"\u0003{\u0011\u0001c\u00155be\u0016\u001cun\u001c:eS:\fGo\u001c:\u0002-\u0011Lh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJ,\"!!\u0013\u0011\u00079\nY%C\u0002\u0002N\u0019\u0012a\u0003R=oC6L7mQ8oM&<\u0007+\u001e2mSNDWM]\u0001\u001bIft\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5fe~#S-\u001d\u000b\u0005\u0003'\nI\u0006E\u00023\u0003+J1!a\u00164\u0005\u0011)f.\u001b;\t\u0013\u0005mS\"!AA\u0002\u0005%\u0013a\u0001=%c\u00059B-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'\u000fI\u0001\u001cIft\u0017-\\5d\u00072LWM\u001c;Rk>$\u0018\rU;cY&\u001c\b.\u001a:\u0011\u00079\n\u0019'C\u0002\u0002f\u0019\u00121\u0004R=oC6L7m\u00117jK:$\u0018+^8uCB+(\r\\5tQ\u0016\u0014\u0018!\t3z]\u0006l\u0017n\u0019+pa&\u001c7\t\\;ti\u0016\u0014\u0018+^8uCB+(\r\\5tQ\u0016\u0014\bc\u0001\u0018\u0002l%\u0019\u0011Q\u000e\u0014\u0003C\u0011Kh.Y7jGR{\u0007/[2DYV\u001cH/\u001a:Rk>$\u0018\rU;cY&\u001c\b.\u001a:\u0002\u001dM\u001c'/Y7Qk\nd\u0017n\u001d5feB\u0019a&a\u001d\n\u0007\u0005UdE\u0001\bTGJ\fW\u000eU;cY&\u001c\b.\u001a:\u00021\u0011,G.Z4bi&|g\u000eV8lK:\u0004VO\u00197jg\",'\u000fE\u0002/\u0003wJ1!! '\u0005a!U\r\\3hCRLwN\u001c+pW\u0016t\u0007+\u001e2mSNDWM]\u0001\rC\u000ed\u0007+\u001e2mSNDWM\u001d\t\u0004]\u0005\r\u0015bAACM\ta\u0011i\u00197Qk\nd\u0017n\u001d5fe\u0006\tb-\u0019;bY\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0011\t\u0005-\u00151S\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u0006)a-Y;mi*\u0011\u0011\u0006S\u0005\u0005\u0003+\u000biI\u0001\u0007GCVdG\u000fS1oI2,'/\u0001\u0010nKR\fG-\u0019;b!V\u0014G.[:iS:<g)Y;mi\"\u000bg\u000e\u001a7feR\u0001\u00131TAO\u0003?\u000b\t+a)\u0002&\u0006\u001d\u0016\u0011VAV\u0003[\u000by+!-\u00024\u0006U\u0016qWA]!\tqC\u0001C\u0003v-\u0001\u0007a\u000fC\u0003{-\u0001\u00071\u0010C\u0003\u007f-\u0001\u0007q\u0010C\u0004\u0002\fY\u0001\r!!\u0004\t\u000f\u0005Ma\u00031\u0001\u0002\u0016!9\u0011Q\u0005\fA\u0002\u0005\u001d\u0002bBA\u001b-\u0001\u0007\u0011q\u0007\u0005\b\u0003\u000b2\u0002\u0019AA%\u0011\u001d\tyF\u0006a\u0001\u0003CBq!a\u001a\u0017\u0001\u0004\tI\u0007C\u0004\u0002pY\u0001\r!!\u001d\t\u000f\u0005]d\u00031\u0001\u0002z!9\u0011q\u0010\fA\u0002\u0005\u0005\u0005bBAD-\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003/3\u0002\u0019AAE\u0003!\u0011'o\\6fe&#WCAA`!\r\u0011\u0014\u0011Y\u0005\u0004\u0003\u0007\u001c$aA%oi\u0006I!M]8lKJLE\rI\u0001\u000e?\u001aL'o\u001d;Qk\nd\u0017n\u001d5\u0016\u0005\u0005-\u0007c\u0001\u001a\u0002N&\u0019\u0011qZ\u001a\u0003\u000f\t{w\u000e\\3b]\u0006\trLZ5sgR\u0004VO\u00197jg\"|F%Z9\u0015\t\u0005M\u0013Q\u001b\u0005\n\u00037R\u0012\u0011!a\u0001\u0003\u0017\fab\u00184jeN$\b+\u001e2mSND\u0007%\u0001\ngSJ\u001cH\u000fU;cY&\u001c\bNR;ukJ,WCAAo!\u0019\ty.!;\u0002n6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/\u0001\u0006d_:\u001cWO\u001d:f]RT1!a:l\u0003\u0011)H/\u001b7\n\t\u0005-\u0018\u0011\u001d\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007c\u00015\u0002p&\u0019\u0011\u0011_5\u0003\tY{\u0017\u000eZ\u0001\u0014M&\u00148\u000f\u001e)vE2L7\u000f\u001b$viV\u0014X\rI\u0001\u0005]\u0006lW\rF\u0001R\u0003Ayg.T3uC\u0012\fG/Y+qI\u0006$X\r\u0006\u0005\u0002T\u0005u\u0018q B\u0001\u0011\u0015\u0011w\u00041\u0001d\u0011\u0015iv\u00041\u0001_\u0011\u001d\u0011\u0019a\ba\u0001\u0005\u000b\t\u0001\"\\1oS\u001a,7\u000f\u001e\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)\u0019!1\u0002$\u0002\r1|\u0017\rZ3s\u0013\u0011\u0011yA!\u0003\u0003\u001d1{\u0017\rZ3s\u001b\u0006t\u0017NZ3ti\u0006iAo\\(qi&|g.\u00197J]R$BA!\u0006\u0003\u001eA!!q\u0003B\r\u001b\t\t)/\u0003\u0003\u0003\u001c\u0005\u0015(aC(qi&|g.\u00197J]RDqAa\b!\u0001\u0004\u0011\t#\u0001\u0004paRLwN\u001c\t\u0005e\t\u000by,A\tva\u0012\fG/Z\"p_J$\u0017N\\1u_J$B\"a\u0015\u0003(\t%\"1\u0006B\u0017\u0005oAQaR\u0011A\u0002yCQAY\u0011A\u0002\rDQ\u0001U\u0011A\u0002ECqAa\f\"\u0001\u0004\u0011\t$\u0001\u0005fY\u0016\u001cG/[8o!%\u0011$1GA`\u0003\u007f\u000b\u0019&C\u0002\u00036M\u0012\u0011BR;oGRLwN\u001c\u001a\t\u000f\te\u0012\u00051\u0001\u0003<\u0005Y!/Z:jO:\fG/[8o!%\u0011$1GA`\u0005C\t\u0019&\u0001\nj]&$\u0018.\u00197ju\u0016l\u0015M\\1hKJ\u001cH\u0003BA*\u0005\u0003BQ!\u0018\u0012A\u0002y\u000b\u0001EZ5oSND\u0017J\\5uS\u0006d\u0017N_5oOJ+\u0007\u000f\\5dC6\u000bg.Y4feR\u0011\u00111K\u0001\u0006G2|7/\u001a")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig config;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final Option<ShareCoordinator> shareCoordinator;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final DynamicTopicClusterQuotaPublisher dynamicTopicClusterQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final DelegationTokenPublisher delegationTokenPublisher;
    private final AclPublisher aclPublisher;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    public String name() {
        return "BrokerMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? "initial MetadataDelta up to " + highestOffsetAndEpoch.offset() : "MetadataDelta up to " + highestOffsetAndEpoch.offset();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Publishing delta " + delta + " with highest offset " + highestOffsetAndEpoch);
                }
                this.metadataCache.setImage(newImage);
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Publishing initial metadata at offset " + highestOffsetAndEpoch + " with " + BrokerMetadataPublisher.metadataVersionLogMsg$1(newImage) + ".");
                    this.initializeManagers(newImage);
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Publishing metadata at offset " + highestOffsetAndEpoch + " with " + BrokerMetadataPublisher.metadataVersionLogMsg$1(newImage) + ".");
                }
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault("Error applying topics delta in " + deltaName, t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(x$1, x$2) -> $this.groupCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionIndex, leaderEpochOpt) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with local changes in " + deltaName, t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault("Error updating txn coordinator with local changes in " + deltaName, t);
                    }
                    if ($this.shareCoordinator.isDefined()) {
                        try {
                            this.updateCoordinator(newImage, delta, "__share_group_state", (Function2<Object, Object, BoxedUnit>)((JFunction2.mcVII.sp & Serializable)(arg_0, arg_1) -> BrokerMetadataPublisher.$anonfun$onMetadataUpdate$9((ShareCoordinator)$this.shareCoordinator.get(), arg_0, arg_1)), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionIndex, leaderEpochOpt) -> {
                                BrokerMetadataPublisher.$anonfun$onMetadataUpdate$10(this, BoxesRunTime.unboxToInt((Object)partitionIndex), leaderEpochOpt);
                                return BoxedUnit.UNIT;
                            });
                        }
                        catch (Throwable t) {
                            $this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with local changes in " + deltaName, t);
                        }
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.onPartitionsDeleted(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)deletedTopicPartitions).asJava(), RequestLocal.noCaching().bufferSupplier());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with deleted partitions in " + deltaName, t);
                    }
                    return runtimeException;
                });
                this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.dynamicTopicClusterQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.scramPublisher.onMetadataUpdate(delta, newImage);
                this.delegationTokenPublisher.onMetadataUpdate(delta, newImage);
                this.aclPublisher.onMetadataUpdate(delta, newImage, manifest);
                try {
                    this.groupCoordinator.onNewMetadataImage(newImage, delta);
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with local changes in " + deltaName, t);
                }
                try {
                    this.shareCoordinator.foreach((Function1 & Serializable)coordinator -> {
                        coordinator.onNewMetadataImage(newImage, delta);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with local changes in " + deltaName, t);
                }
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager();
                }
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault("Uncaught exception while publishing broker metadata from " + deltaName, t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
            this.firstPublishFuture().complete(null);
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        if (option instanceof Some) {
            return OptionalInt.of(BoxesRunTime.unboxToInt((Object)((Some)option).value()));
        }
        if (None$.MODULE$.equals(option)) {
            return OptionalInt.empty();
        }
        throw new MatchError(option);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers(MetadataImage newImage) {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics(), (Function1<UnifiedLog, Object>)(Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)LogManager$.MODULE$.isStrayKraftReplica(this.brokerId(), newImage.topics(), log)));
            this.logManager.recoverAbandonedFutureLogs(this.brokerId(), newImage.topics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$2(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.config.groupCoordinatorConfig().offsetsTopicPartitions())));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.config.transactionLogConfig().transactionTopicPartitions())), this.txnCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
        }
        if (this.config.shareGroupConfig().isShareGroupEnabled() && this.shareCoordinator.isDefined()) {
            try {
                ((ShareCoordinator)this.shareCoordinator.get()).startup(() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__share_group_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.config.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions())));
                return;
            }
            catch (Throwable t) {
                this.fatalFaultHandler.handleFault("Error starting Share coordinator", t);
                return;
            }
        }
    }

    private void finishInitializingReplicaManager() {
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public void close() {
        this.firstPublishFuture().completeExceptionally((Throwable)new TimeoutException());
    }

    private static final String metadataVersionLogMsg$1(MetadataImage newImage$1) {
        return "metadata.version " + newImage$1.features().metadataVersion();
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$9(ShareCoordinator eta$0$1$1, int x$1, int x$2) {
        eta$0$1$1.onElection(x$1, x$2);
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$10(BrokerMetadataPublisher $this, int partitionIndex, Option leaderEpochOpt) {
        ((ShareCoordinator)$this.shareCoordinator.get()).onResignation(partitionIndex, $this.toOptionalInt((Option<Object>)leaderEpochOpt));
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)None$.MODULE$);
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.electedLeaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$2(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.config.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig config, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, Option<ShareCoordinator> shareCoordinator, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, DynamicTopicClusterQuotaPublisher dynamicTopicClusterQuotaPublisher, ScramPublisher scramPublisher, DelegationTokenPublisher delegationTokenPublisher, AclPublisher aclPublisher, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler) {
        this.config = config;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.dynamicTopicClusterQuotaPublisher = dynamicTopicClusterQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this.delegationTokenPublisher = delegationTokenPublisher;
        this.aclPublisher = aclPublisher;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.logIdent_$eq("[BrokerMetadataPublisher id=" + config.nodeId() + "] ");
        this.brokerId = config.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
    }
}

