/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.coordinator.group.modern.SubscriptionCount;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineInteger;
import org.apache.kafka.timeline.TimelineObject;

public abstract class ModernGroup<T extends ModernGroupMember>
implements Group {
    protected final SnapshotRegistry snapshotRegistry;
    protected final String groupId;
    protected final TimelineInteger groupEpoch;
    protected final TimelineHashMap<String, T> members;
    protected final TimelineHashMap<String, SubscriptionCount> subscribedTopicNames;
    protected final TimelineHashMap<String, TopicMetadata> subscribedTopicMetadata;
    protected final TimelineObject<SubscriptionType> subscriptionType;
    protected final TimelineInteger targetAssignmentEpoch;
    protected final TimelineHashMap<String, Assignment> targetAssignment;
    private final TimelineHashMap<Uuid, TimelineHashMap<Integer, String>> invertedTargetAssignment;
    protected DeadlineAndEpoch metadataRefreshDeadline = DeadlineAndEpoch.EMPTY;

    protected ModernGroup(SnapshotRegistry snapshotRegistry, String groupId) {
        this.snapshotRegistry = Objects.requireNonNull(snapshotRegistry);
        this.groupId = Objects.requireNonNull(groupId);
        this.groupEpoch = new TimelineInteger(snapshotRegistry);
        this.members = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedTopicNames = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedTopicMetadata = new TimelineHashMap(snapshotRegistry, 0);
        this.subscriptionType = new TimelineObject(snapshotRegistry, (Object)SubscriptionType.HOMOGENEOUS);
        this.targetAssignmentEpoch = new TimelineInteger(snapshotRegistry);
        this.targetAssignment = new TimelineHashMap(snapshotRegistry, 0);
        this.invertedTargetAssignment = new TimelineHashMap(snapshotRegistry, 0);
    }

    @Override
    public ListGroupsResponseData.ListedGroup asListedGroup(long committedOffset) {
        return new ListGroupsResponseData.ListedGroup().setGroupId(this.groupId).setProtocolType(this.protocolType()).setGroupState(this.stateAsString(committedOffset)).setGroupType(this.type().toString());
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    public int groupEpoch() {
        return this.groupEpoch.get();
    }

    public void setGroupEpoch(int groupEpoch) {
        this.groupEpoch.set(groupEpoch);
        this.maybeUpdateGroupState();
    }

    public int assignmentEpoch() {
        return this.targetAssignmentEpoch.get();
    }

    public void setTargetAssignmentEpoch(int targetAssignmentEpoch) {
        this.targetAssignmentEpoch.set(targetAssignmentEpoch);
        this.maybeUpdateGroupState();
    }

    @Override
    public boolean hasMember(String memberId) {
        return this.members.containsKey((Object)memberId);
    }

    @Override
    public int numMembers() {
        return this.members.size();
    }

    public Map<String, T> members() {
        return Collections.unmodifiableMap(this.members);
    }

    public Map<String, SubscriptionCount> subscribedTopicNames() {
        return Collections.unmodifiableMap(this.subscribedTopicNames);
    }

    @Override
    public boolean isSubscribedToTopic(String topic) {
        return this.subscribedTopicNames.containsKey((Object)topic);
    }

    public SubscriptionType subscriptionType() {
        return (SubscriptionType)this.subscriptionType.get();
    }

    public Assignment targetAssignment(String memberId) {
        return (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)Assignment.EMPTY);
    }

    public Map<Uuid, Map<Integer, String>> invertedTargetAssignment() {
        return Collections.unmodifiableMap(this.invertedTargetAssignment);
    }

    public void updateTargetAssignment(String memberId, Assignment newTargetAssignment) {
        this.updateInvertedTargetAssignment(memberId, (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)new Assignment(Collections.emptyMap())), newTargetAssignment);
        this.targetAssignment.put((Object)memberId, (Object)newTargetAssignment);
    }

    private void updateInvertedTargetAssignment(String memberId, Assignment oldTargetAssignment, Assignment newTargetAssignment) {
        HashSet<Uuid> allTopicIds = new HashSet<Uuid>();
        allTopicIds.addAll(oldTargetAssignment.partitions().keySet());
        allTopicIds.addAll(newTargetAssignment.partitions().keySet());
        for (Uuid topicId : allTopicIds) {
            Set oldPartitions = oldTargetAssignment.partitions().getOrDefault(topicId, Collections.emptySet());
            Set newPartitions = newTargetAssignment.partitions().getOrDefault(topicId, Collections.emptySet());
            TimelineHashMap topicPartitionAssignment = (TimelineHashMap)this.invertedTargetAssignment.computeIfAbsent((Object)topicId, k -> new TimelineHashMap(this.snapshotRegistry, Math.max(oldPartitions.size(), newPartitions.size())));
            for (Integer partition : oldPartitions) {
                if (newPartitions.contains(partition) || !memberId.equals(topicPartitionAssignment.get((Object)partition))) continue;
                topicPartitionAssignment.remove((Object)partition);
            }
            for (Integer partition : newPartitions) {
                if (oldPartitions.contains(partition)) continue;
                topicPartitionAssignment.put((Object)partition, (Object)memberId);
            }
            if (topicPartitionAssignment.isEmpty()) {
                this.invertedTargetAssignment.remove((Object)topicId);
                continue;
            }
            this.invertedTargetAssignment.put((Object)topicId, (Object)topicPartitionAssignment);
        }
    }

    public void removeTargetAssignment(String memberId) {
        this.updateInvertedTargetAssignment(memberId, (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)Assignment.EMPTY), Assignment.EMPTY);
        this.targetAssignment.remove((Object)memberId);
    }

    public Map<String, Assignment> targetAssignment() {
        return Collections.unmodifiableMap(this.targetAssignment);
    }

    public Map<String, TopicMetadata> subscriptionMetadata() {
        return Collections.unmodifiableMap(this.subscribedTopicMetadata);
    }

    public void setSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscribedTopicMetadata.clear();
        this.subscribedTopicMetadata.putAll(subscriptionMetadata);
    }

    public Map<String, TopicMetadata> computeSubscriptionMetadata(Map<String, SubscriptionCount> subscribedTopicNames, TopicsImage topicsImage, ClusterImage clusterImage) {
        HashMap newSubscriptionMetadata = new HashMap(subscribedTopicNames.size());
        subscribedTopicNames.forEach((topicName, count) -> {
            TopicImage topicImage = topicsImage.getTopic(topicName);
            if (topicImage != null) {
                newSubscriptionMetadata.put(topicName, new TopicMetadata(topicImage.id(), topicImage.name(), topicImage.partitions().size()));
            }
        });
        return Collections.unmodifiableMap(newSubscriptionMetadata);
    }

    public void setMetadataRefreshDeadline(long deadlineMs, int groupEpoch) {
        this.metadataRefreshDeadline = new DeadlineAndEpoch(deadlineMs, groupEpoch);
    }

    public void requestMetadataRefresh() {
        this.metadataRefreshDeadline = DeadlineAndEpoch.EMPTY;
    }

    public boolean hasMetadataExpired(long currentTimeMs) {
        return currentTimeMs >= this.metadataRefreshDeadline.deadlineMs || this.groupEpoch() < this.metadataRefreshDeadline.epoch;
    }

    public DeadlineAndEpoch metadataRefreshDeadline() {
        return this.metadataRefreshDeadline;
    }

    protected void maybeUpdateGroupSubscriptionType() {
        this.subscriptionType.set((Object)ModernGroup.subscriptionType(this.subscribedTopicNames, this.members.size()));
    }

    protected void maybeUpdateSubscribedTopicNames(ModernGroupMember oldMember, ModernGroupMember newMember) {
        ModernGroup.maybeUpdateSubscribedTopicNames(this.subscribedTopicNames, oldMember, newMember);
    }

    private static void maybeUpdateSubscribedTopicNames(Map<String, SubscriptionCount> subscribedTopicCount, ModernGroupMember oldMember, ModernGroupMember newMember) {
        if (oldMember != null) {
            oldMember.subscribedTopicNames().forEach(topicName -> subscribedTopicCount.compute((String)topicName, SubscriptionCount::decNameCount));
        }
        if (newMember != null) {
            newMember.subscribedTopicNames().forEach(topicName -> subscribedTopicCount.compute((String)topicName, SubscriptionCount::incNameCount));
        }
    }

    public Map<String, SubscriptionCount> computeSubscribedTopicNames(ModernGroupMember oldMember, ModernGroupMember newMember) {
        HashMap<String, SubscriptionCount> subscribedTopicNames = new HashMap<String, SubscriptionCount>((Map<String, SubscriptionCount>)this.subscribedTopicNames);
        ModernGroup.maybeUpdateSubscribedTopicNames(subscribedTopicNames, oldMember, newMember);
        return subscribedTopicNames;
    }

    public Map<String, SubscriptionCount> computeSubscribedTopicNames(Set<? extends ModernGroupMember> removedMembers) {
        HashMap<String, SubscriptionCount> subscribedTopicNames = new HashMap<String, SubscriptionCount>((Map<String, SubscriptionCount>)this.subscribedTopicNames);
        if (removedMembers != null) {
            removedMembers.forEach(removedMember -> ModernGroup.maybeUpdateSubscribedTopicNames(subscribedTopicNames, removedMember, null));
        }
        return subscribedTopicNames;
    }

    public static SubscriptionType subscriptionType(Map<String, SubscriptionCount> subscribedTopicNames, int numberOfMembers) {
        if (subscribedTopicNames.isEmpty()) {
            return SubscriptionType.HOMOGENEOUS;
        }
        for (SubscriptionCount subscriberCount : subscribedTopicNames.values()) {
            if (subscriberCount.byNameCount == numberOfMembers) continue;
            return SubscriptionType.HETEROGENEOUS;
        }
        return SubscriptionType.HOMOGENEOUS;
    }

    public abstract String protocolType();

    public abstract T getOrMaybeCreateMember(String var1, boolean var2) throws UnknownMemberIdException;

    public abstract void updateMember(T var1);

    public abstract void removeMember(String var1);

    protected abstract void maybeUpdateGroupState();

    public static class DeadlineAndEpoch {
        static final DeadlineAndEpoch EMPTY = new DeadlineAndEpoch(0L, 0);
        public final long deadlineMs;
        public final int epoch;

        DeadlineAndEpoch(long deadlineMs, int epoch) {
            this.deadlineMs = deadlineMs;
            this.epoch = epoch;
        }
    }
}

