/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;
import org.apache.kafka.coordinator.group.modern.ModernGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineObject;

public class ShareGroup
extends ModernGroup<ShareGroupMember> {
    public static final String PROTOCOL_TYPE = "share";
    private final TimelineObject<ShareGroupState> state;

    public ShareGroup(SnapshotRegistry snapshotRegistry, String groupId) {
        super(snapshotRegistry, groupId);
        this.state = new TimelineObject(snapshotRegistry, (Object)ShareGroupState.EMPTY);
    }

    @Override
    public Group.GroupType type() {
        return Group.GroupType.SHARE;
    }

    @Override
    public String protocolType() {
        return PROTOCOL_TYPE;
    }

    @Override
    public String stateAsString() {
        return ((ShareGroupState)((Object)this.state.get())).toString();
    }

    @Override
    public String stateAsString(long committedOffset) {
        return ((ShareGroupState)((Object)this.state.get(committedOffset))).toString();
    }

    public ShareGroupState state() {
        return (ShareGroupState)((Object)this.state.get());
    }

    public ShareGroupState state(long committedOffset) {
        return (ShareGroupState)((Object)this.state.get(committedOffset));
    }

    @Override
    public ShareGroupMember getOrMaybeCreateMember(String memberId, boolean createIfNotExists) throws UnknownMemberIdException {
        ShareGroupMember member = (ShareGroupMember)this.members.get((Object)memberId);
        if (member != null) {
            return member;
        }
        if (!createIfNotExists) {
            throw new UnknownMemberIdException(String.format("Member %s is not a member of group %s.", memberId, this.groupId));
        }
        member = new ShareGroupMember.Builder(memberId).build();
        this.updateMember(member);
        return member;
    }

    @Override
    public void updateMember(ShareGroupMember newMember) {
        if (newMember == null) {
            throw new IllegalArgumentException("newMember cannot be null.");
        }
        ShareGroupMember oldMember = (ShareGroupMember)this.members.put((Object)newMember.memberId(), (Object)newMember);
        this.maybeUpdateSubscribedTopicNames(oldMember, newMember);
        this.maybeUpdateGroupState();
        this.maybeUpdateGroupSubscriptionType();
    }

    @Override
    public void removeMember(String memberId) {
        ShareGroupMember oldMember = (ShareGroupMember)this.members.remove((Object)memberId);
        this.maybeUpdateSubscribedTopicNames(oldMember, null);
        this.maybeUpdateGroupState();
        this.maybeUpdateGroupSubscriptionType();
    }

    @Override
    public void validateOffsetCommit(String memberId, String groupInstanceId, int memberEpoch, boolean isTransactional, short apiVersion) {
        throw new GroupIdNotFoundException(String.format("Group %s is not a consumer group.", this.groupId));
    }

    @Override
    public void validateOffsetFetch(String memberId, int memberEpoch, long lastCommittedOffset) {
        throw new GroupIdNotFoundException(String.format("Group %s is not a consumer group.", this.groupId));
    }

    @Override
    public void validateOffsetDelete() {
        throw new GroupIdNotFoundException(String.format("Group %s is not a consumer group.", this.groupId));
    }

    @Override
    public void validateDeleteGroup() throws ApiException {
        if (this.state() != ShareGroupState.EMPTY) {
            throw Errors.NON_EMPTY_GROUP.exception();
        }
    }

    @Override
    public void createGroupTombstoneRecords(List<CoordinatorRecord> records) {
        this.members().forEach((memberId, member) -> records.add(GroupCoordinatorRecordHelpers.newShareGroupCurrentAssignmentTombstoneRecord(this.groupId(), memberId)));
        this.members().forEach((memberId, member) -> records.add(GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentTombstoneRecord(this.groupId(), memberId)));
        records.add(GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentEpochTombstoneRecord(this.groupId()));
        this.members().forEach((memberId, member) -> records.add(GroupCoordinatorRecordHelpers.newShareGroupMemberSubscriptionTombstoneRecord(this.groupId(), memberId)));
        records.add(GroupCoordinatorRecordHelpers.newShareGroupSubscriptionMetadataTombstoneRecord(this.groupId()));
        records.add(GroupCoordinatorRecordHelpers.newShareGroupEpochTombstoneRecord(this.groupId()));
    }

    @Override
    public boolean isEmpty() {
        return this.state() == ShareGroupState.EMPTY;
    }

    @Override
    public Optional<OffsetExpirationCondition> offsetExpirationCondition() {
        throw new UnsupportedOperationException("offsetExpirationCondition is not supported for Share Groups.");
    }

    @Override
    public boolean isInStates(Set<String> statesFilter, long committedOffset) {
        return statesFilter.contains(((ShareGroupState)((Object)this.state.get(committedOffset))).toLowerCaseString());
    }

    @Override
    protected void maybeUpdateGroupState() {
        ShareGroupState newState = ShareGroupState.STABLE;
        if (this.members.isEmpty()) {
            newState = ShareGroupState.EMPTY;
        }
        this.state.set((Object)newState);
    }

    public ShareGroupDescribeResponseData.DescribedGroup asDescribedGroup(long committedOffset, String defaultAssignor, TopicsImage topicsImage) {
        ShareGroupDescribeResponseData.DescribedGroup describedGroup = new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(this.groupId).setAssignorName(defaultAssignor).setGroupEpoch(this.groupEpoch.get(committedOffset)).setGroupState(((ShareGroupState)((Object)this.state.get(committedOffset))).toString()).setAssignmentEpoch(this.targetAssignmentEpoch.get(committedOffset));
        this.members.entrySet(committedOffset).forEach(entry -> describedGroup.members().add(((ShareGroupMember)entry.getValue()).asShareGroupDescribeMember(topicsImage)));
        return describedGroup;
    }

    public static enum ShareGroupState {
        EMPTY("Empty"),
        STABLE("Stable"),
        DEAD("Dead"),
        UNKNOWN("Unknown");

        private final String name;
        private final String lowerCaseName;

        private ShareGroupState(String name) {
            this.name = name;
            this.lowerCaseName = name.toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.name;
        }

        public String toLowerCaseString() {
            return this.lowerCaseName;
        }
    }
}

