/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Objects;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.SnapshotFooterRecord;
import org.apache.kafka.common.message.SnapshotHeaderRecord;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.ControlRecordType;

public final class ControlRecord {
    private final ControlRecordType recordType;
    private final ApiMessage message;

    private static void throwIllegalArgument(ControlRecordType recordType, ApiMessage message) {
        throw new IllegalArgumentException(String.format("Record type %s doesn't match message class %s", recordType, message.getClass()));
    }

    public ControlRecord(ControlRecordType recordType, ApiMessage message) {
        switch (recordType) {
            case LEADER_CHANGE: {
                if (message instanceof LeaderChangeMessage) break;
                ControlRecord.throwIllegalArgument(recordType, message);
                break;
            }
            case SNAPSHOT_HEADER: {
                if (message instanceof SnapshotHeaderRecord) break;
                ControlRecord.throwIllegalArgument(recordType, message);
                break;
            }
            case SNAPSHOT_FOOTER: {
                if (message instanceof SnapshotFooterRecord) break;
                ControlRecord.throwIllegalArgument(recordType, message);
                break;
            }
            case KRAFT_VERSION: {
                if (message instanceof KRaftVersionRecord) break;
                ControlRecord.throwIllegalArgument(recordType, message);
                break;
            }
            case KRAFT_VOTERS: {
                if (message instanceof VotersRecord) break;
                ControlRecord.throwIllegalArgument(recordType, message);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown control record type %s", recordType));
            }
        }
        this.recordType = recordType;
        this.message = message;
    }

    public ControlRecordType type() {
        return this.recordType;
    }

    public short version() {
        switch (this.recordType) {
            case LEADER_CHANGE: {
                return ((LeaderChangeMessage)this.message).version();
            }
            case SNAPSHOT_HEADER: {
                return ((SnapshotHeaderRecord)this.message).version();
            }
            case SNAPSHOT_FOOTER: {
                return ((SnapshotFooterRecord)this.message).version();
            }
            case KRAFT_VERSION: {
                return ((KRaftVersionRecord)this.message).version();
            }
            case KRAFT_VOTERS: {
                return ((VotersRecord)this.message).version();
            }
        }
        throw new IllegalStateException(String.format("Unknown control record type %s", this.recordType));
    }

    public ApiMessage message() {
        return this.message;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ControlRecord that = (ControlRecord)other;
        return Objects.equals(this.recordType, that.recordType) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.recordType, this.message);
    }

    public String toString() {
        return String.format("ControlRecord(recordType=%s, message=%s)", this.recordType, this.message);
    }
}

