/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.message.UpdateRaftVoterResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftUtil;

public final class UpdateVoterHandlerState {
    private final long lastOffset;
    private final ListenerName requestListenerName;
    private final Timer timeout;
    private final CompletableFuture<UpdateRaftVoterResponseData> future = new CompletableFuture();

    UpdateVoterHandlerState(long lastOffset, ListenerName requestListenerName, Timer timeout) {
        this.lastOffset = lastOffset;
        this.requestListenerName = requestListenerName;
        this.timeout = timeout;
    }

    public long timeUntilOperationExpiration(long currentTimeMs) {
        this.timeout.update(currentTimeMs);
        return this.timeout.remainingMs();
    }

    public CompletableFuture<UpdateRaftVoterResponseData> future() {
        return this.future;
    }

    public void completeFuture(Errors error, LeaderAndEpoch leaderAndEpoch, Endpoints leaderEndpoints) {
        this.future.complete(RaftUtil.updateVoterResponse(error, this.requestListenerName, leaderAndEpoch, leaderEndpoints));
    }

    public long lastOffset() {
        return this.lastOffset;
    }
}

