/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Frequencies;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.apache.kafka.connect.runtime.ConnectMetricsRegistry;
import org.apache.kafka.connect.runtime.ConnectorStatus;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.WorkerConnector;
import org.apache.kafka.connect.runtime.WorkerTask;
import org.apache.kafka.connect.util.ConnectorTaskId;

class WorkerMetricsGroup {
    private final ConnectMetrics.MetricGroup metricGroup;
    private final Sensor connectorStartupAttempts;
    private final Sensor connectorStartupSuccesses;
    private final Sensor connectorStartupFailures;
    private final Sensor connectorStartupResults;
    private final Sensor taskStartupAttempts;
    private final Sensor taskStartupSuccesses;
    private final Sensor taskStartupFailures;
    private final Sensor taskStartupResults;

    public WorkerMetricsGroup(Map<String, WorkerConnector> connectors, Map<ConnectorTaskId, WorkerTask<?, ?>> tasks, ConnectMetrics connectMetrics) {
        ConnectMetricsRegistry registry = connectMetrics.registry();
        this.metricGroup = connectMetrics.group(registry.workerGroupName(), new String[0]);
        this.metricGroup.addValueMetric(registry.connectorCount, now -> connectors.size());
        this.metricGroup.addValueMetric(registry.taskCount, now -> tasks.size());
        MetricName connectorFailurePct = this.metricGroup.metricName(registry.connectorStartupFailurePercentage);
        MetricName connectorSuccessPct = this.metricGroup.metricName(registry.connectorStartupSuccessPercentage);
        Frequencies connectorStartupResultFrequencies = Frequencies.forBooleanValues((MetricName)connectorFailurePct, (MetricName)connectorSuccessPct);
        this.connectorStartupResults = this.metricGroup.sensor("connector-startup-results");
        this.connectorStartupResults.add((CompoundStat)connectorStartupResultFrequencies);
        this.connectorStartupAttempts = this.metricGroup.sensor("connector-startup-attempts");
        this.connectorStartupAttempts.add(this.metricGroup.metricName(registry.connectorStartupAttemptsTotal), (MeasurableStat)new CumulativeSum());
        this.connectorStartupSuccesses = this.metricGroup.sensor("connector-startup-successes");
        this.connectorStartupSuccesses.add(this.metricGroup.metricName(registry.connectorStartupSuccessTotal), (MeasurableStat)new CumulativeSum());
        this.connectorStartupFailures = this.metricGroup.sensor("connector-startup-failures");
        this.connectorStartupFailures.add(this.metricGroup.metricName(registry.connectorStartupFailureTotal), (MeasurableStat)new CumulativeSum());
        MetricName taskFailurePct = this.metricGroup.metricName(registry.taskStartupFailurePercentage);
        MetricName taskSuccessPct = this.metricGroup.metricName(registry.taskStartupSuccessPercentage);
        Frequencies taskStartupResultFrequencies = Frequencies.forBooleanValues((MetricName)taskFailurePct, (MetricName)taskSuccessPct);
        this.taskStartupResults = this.metricGroup.sensor("task-startup-results");
        this.taskStartupResults.add((CompoundStat)taskStartupResultFrequencies);
        this.taskStartupAttempts = this.metricGroup.sensor("task-startup-attempts");
        this.taskStartupAttempts.add(this.metricGroup.metricName(registry.taskStartupAttemptsTotal), (MeasurableStat)new CumulativeSum());
        this.taskStartupSuccesses = this.metricGroup.sensor("task-startup-successes");
        this.taskStartupSuccesses.add(this.metricGroup.metricName(registry.taskStartupSuccessTotal), (MeasurableStat)new CumulativeSum());
        this.taskStartupFailures = this.metricGroup.sensor("task-startup-failures");
        this.taskStartupFailures.add(this.metricGroup.metricName(registry.taskStartupFailureTotal), (MeasurableStat)new CumulativeSum());
    }

    void close() {
        this.metricGroup.close();
    }

    void recordConnectorStartupFailure() {
        this.connectorStartupAttempts.record(1.0);
        this.connectorStartupFailures.record(1.0);
        this.connectorStartupResults.record(0.0);
    }

    void recordConnectorStartupSuccess() {
        this.connectorStartupAttempts.record(1.0);
        this.connectorStartupSuccesses.record(1.0);
        this.connectorStartupResults.record(1.0);
    }

    void recordTaskFailure() {
        this.taskStartupAttempts.record(1.0);
        this.taskStartupFailures.record(1.0);
        this.taskStartupResults.record(0.0);
    }

    void recordTaskSuccess() {
        this.taskStartupAttempts.record(1.0);
        this.taskStartupSuccesses.record(1.0);
        this.taskStartupResults.record(1.0);
    }

    protected ConnectMetrics.MetricGroup metricGroup() {
        return this.metricGroup;
    }

    ConnectorStatus.Listener wrapStatusListener(ConnectorStatus.Listener delegateListener) {
        return new ConnectorStatusListener(delegateListener);
    }

    TaskStatus.Listener wrapStatusListener(TaskStatus.Listener delegateListener) {
        return new TaskStatusListener(delegateListener);
    }

    class ConnectorStatusListener
    implements ConnectorStatus.Listener {
        private final ConnectorStatus.Listener delegateListener;
        private volatile boolean startupSucceeded = false;

        ConnectorStatusListener(ConnectorStatus.Listener delegateListener) {
            this.delegateListener = delegateListener;
        }

        @Override
        public void onStartup(String connector) {
            this.startupSucceeded = true;
            WorkerMetricsGroup.this.recordConnectorStartupSuccess();
            this.delegateListener.onStartup(connector);
        }

        @Override
        public void onStop(String connector) {
            this.delegateListener.onStop(connector);
        }

        @Override
        public void onPause(String connector) {
            this.delegateListener.onPause(connector);
        }

        @Override
        public void onResume(String connector) {
            this.delegateListener.onResume(connector);
        }

        @Override
        public void onFailure(String connector, Throwable cause) {
            if (!this.startupSucceeded) {
                WorkerMetricsGroup.this.recordConnectorStartupFailure();
            }
            this.delegateListener.onFailure(connector, cause);
        }

        @Override
        public void onRestart(String connector) {
            this.delegateListener.onRestart(connector);
        }

        @Override
        public void onShutdown(String connector) {
            this.delegateListener.onShutdown(connector);
        }

        @Override
        public void onDeletion(String connector) {
            this.delegateListener.onDeletion(connector);
        }
    }

    class TaskStatusListener
    implements TaskStatus.Listener {
        private final TaskStatus.Listener delegatedListener;
        private volatile boolean startupSucceeded = false;

        TaskStatusListener(TaskStatus.Listener delegatedListener) {
            this.delegatedListener = delegatedListener;
        }

        @Override
        public void onStartup(ConnectorTaskId id) {
            WorkerMetricsGroup.this.recordTaskSuccess();
            this.startupSucceeded = true;
            this.delegatedListener.onStartup(id);
        }

        @Override
        public void onPause(ConnectorTaskId id) {
            this.delegatedListener.onPause(id);
        }

        @Override
        public void onResume(ConnectorTaskId id) {
            this.delegatedListener.onResume(id);
        }

        @Override
        public void onFailure(ConnectorTaskId id, Throwable cause) {
            if (!this.startupSucceeded) {
                WorkerMetricsGroup.this.recordTaskFailure();
            }
            this.delegatedListener.onFailure(id, cause);
        }

        @Override
        public void onRestart(ConnectorTaskId id) {
            this.delegatedListener.onRestart(id);
        }

        @Override
        public void onShutdown(ConnectorTaskId id) {
            this.delegatedListener.onShutdown(id);
        }

        @Override
        public void onDeletion(ConnectorTaskId id) {
            this.delegatedListener.onDeletion(id);
        }
    }
}

