/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Vector;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    private final URL pluginLocation;

    public PluginClassLoader(URL pluginLocation, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.pluginLocation = Objects.requireNonNull(pluginLocation, "Plugin location must be non-null");
    }

    public String location() {
        return this.pluginLocation.toString();
    }

    public String toString() {
        return "PluginClassLoader{pluginLocation=" + String.valueOf(this.pluginLocation) + "}";
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        URL url;
        Objects.requireNonNull(name);
        Vector<URL> resources = new Vector<URL>();
        Enumeration<URL> foundLocally = this.findResources(name);
        while (foundLocally.hasMoreElements()) {
            url = foundLocally.nextElement();
            if (url == null) continue;
            resources.add(url);
        }
        Enumeration<URL> foundByParent = this.getParent().getResources(name);
        while (foundByParent.hasMoreElements()) {
            url = foundByParent.nextElement();
            if (url == null) continue;
            resources.add(url);
        }
        return resources.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> klass = this.findLoadedClass(name);
            if (klass == null) {
                try {
                    if (PluginUtils.shouldLoadInIsolation(name)) {
                        klass = this.findClass(name);
                    }
                }
                catch (ClassNotFoundException e) {
                    log.trace("Class '{}' not found. Delegating to parent", (Object)name);
                }
            }
            if (klass == null) {
                klass = super.loadClass(name, false);
            }
            if (resolve) {
                this.resolveClass(klass);
            }
            return klass;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

