/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Objects;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;

public class LogOffsetSnapshot {
    public final long logStartOffset;
    public final LogOffsetMetadata logEndOffset;
    public final LogOffsetMetadata highWatermark;
    public final LogOffsetMetadata lastStableOffset;

    public LogOffsetSnapshot(long logStartOffset, LogOffsetMetadata logEndOffset, LogOffsetMetadata highWatermark, LogOffsetMetadata lastStableOffset) {
        this.logStartOffset = logStartOffset;
        this.logEndOffset = logEndOffset;
        this.highWatermark = highWatermark;
        this.lastStableOffset = lastStableOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogOffsetSnapshot that = (LogOffsetSnapshot)o;
        return this.logStartOffset == that.logStartOffset && Objects.equals(this.logEndOffset, that.logEndOffset) && Objects.equals(this.highWatermark, that.highWatermark) && Objects.equals(this.lastStableOffset, that.lastStableOffset);
    }

    public int hashCode() {
        int result = (int)(this.logStartOffset ^ this.logStartOffset >>> 32);
        result = 31 * result + (this.logEndOffset != null ? this.logEndOffset.hashCode() : 0);
        result = 31 * result + (this.highWatermark != null ? this.highWatermark.hashCode() : 0);
        result = 31 * result + (this.lastStableOffset != null ? this.lastStableOffset.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LogOffsetSnapshot(logStartOffset=" + this.logStartOffset + ", logEndOffset=" + String.valueOf(this.logEndOffset) + ", highWatermark=" + String.valueOf(this.highWatermark) + ", lastStableOffset=" + String.valueOf(this.lastStableOffset) + ")";
    }
}

