/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;

public class TopicOptionalIdPartition {
    private final Optional<Uuid> topicId;
    private final TopicPartition topicPartition;

    public TopicOptionalIdPartition(Optional<Uuid> topicId, TopicPartition topicPartition) {
        this.topicId = topicId;
        this.topicPartition = Objects.requireNonNull(topicPartition, "topicPartition can not be null");
    }

    public Optional<Uuid> topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicOptionalIdPartition that = (TopicOptionalIdPartition)o;
        return this.topicId.equals(that.topicId) && this.topicPartition.equals((Object)that.topicPartition);
    }

    public int hashCode() {
        int prime = 31;
        int result = 0;
        if (this.topicId.isPresent()) {
            result = 31 + this.topicId.get().hashCode();
        }
        result = 31 * result + this.topicPartition.hashCode();
        return result;
    }

    public String toString() {
        return this.topicId.map(uuid -> String.valueOf(uuid) + ":" + this.topic() + "-" + this.partition()).orElseGet(() -> "none:" + this.topic() + "-" + this.partition());
    }
}

