/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLock.class);
    private final File file;
    private final FileChannel channel;
    private java.nio.channels.FileLock flock;

    public FileLock(File file) throws IOException {
        this.file = file;
        this.channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    public File file() {
        return this.file;
    }

    public synchronized void lock() throws IOException {
        LOGGER.trace("Acquiring lock on {}", (Object)this.file.getAbsolutePath());
        this.flock = this.channel.lock();
    }

    public synchronized boolean tryLock() throws IOException {
        LOGGER.trace("Acquiring lock on {}", (Object)this.file.getAbsolutePath());
        try {
            this.flock = this.channel.tryLock();
            return this.flock != null;
        }
        catch (OverlappingFileLockException e) {
            return false;
        }
    }

    public synchronized void unlock() throws IOException {
        LOGGER.trace("Releasing lock on {}", (Object)this.file.getAbsolutePath());
        if (this.flock != null) {
            this.flock.release();
        }
    }

    public synchronized void destroy() throws IOException {
        this.unlock();
        if (this.file.exists() && this.file.delete()) {
            LOGGER.trace("Deleted {}", (Object)this.file.getAbsolutePath());
        }
        this.channel.close();
    }

    public synchronized void unlockAndClose() throws IOException {
        this.unlock();
        this.channel.close();
    }
}

