/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamImplJoin;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;

public abstract class AbstractKStreamTimeWindowAggregateProcessor<KIn, VIn, VAgg>
extends ContextualProcessor<KIn, VIn, Windowed<KIn>, Change<VAgg>> {
    private final Time time = Time.SYSTEM;
    private final String storeName;
    private final EmitStrategy emitStrategy;
    private final boolean sendOldValues;
    protected final KStreamImplJoin.TimeTracker timeTracker = new KStreamImplJoin.TimeTracker();
    private TimestampedTupleForwarder<Windowed<KIn>, VAgg> tupleForwarder;
    protected TimestampedWindowStore<KIn, VAgg> windowStore;
    protected Sensor droppedRecordsSensor;
    protected Sensor emittedRecordsSensor;
    protected Sensor emitFinalLatencySensor;
    protected long lastEmitWindowCloseTime = -1L;
    protected long observedStreamTime = -1L;
    protected InternalProcessorContext<Windowed<KIn>, Change<VAgg>> internalProcessorContext;

    protected AbstractKStreamTimeWindowAggregateProcessor(String storeName, EmitStrategy emitStrategy, boolean sendOldValues) {
        this.storeName = storeName;
        this.emitStrategy = emitStrategy;
        this.sendOldValues = sendOldValues;
    }

    @Override
    public void init(ProcessorContext<Windowed<KIn>, Change<VAgg>> context) {
        super.init(context);
        this.internalProcessorContext = (InternalProcessorContext)context;
        StreamsMetricsImpl metrics = this.internalProcessorContext.metrics();
        String threadId = Thread.currentThread().getName();
        String processorName = this.internalProcessorContext.currentNode().name();
        this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(threadId, context.taskId().toString(), metrics);
        this.emittedRecordsSensor = ProcessorNodeMetrics.emittedRecordsSensor(threadId, context.taskId().toString(), processorName, metrics);
        this.emitFinalLatencySensor = ProcessorNodeMetrics.emitFinalLatencySensor(threadId, context.taskId().toString(), processorName, metrics);
        this.windowStore = (TimestampedWindowStore)context.getStateStore(this.storeName);
        if (this.emitStrategy.type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
            Long lastEmitWindowCloseTime = this.internalProcessorContext.processorMetadataForKey(this.storeName);
            if (lastEmitWindowCloseTime != null) {
                this.lastEmitWindowCloseTime = lastEmitWindowCloseTime;
            }
            long emitInterval = StreamsConfig.InternalConfig.getLong(context.appConfigs(), "__emit.interval.ms.kstreams.windowed.aggregation__", 1000L);
            this.timeTracker.setEmitInterval(emitInterval);
            this.tupleForwarder = new TimestampedTupleForwarder<Windowed<KIn>, VAgg>(context, this.sendOldValues);
        } else {
            this.tupleForwarder = new TimestampedTupleForwarder<Windowed<KIn>, VAgg>(this.windowStore, context, new TimestampedCacheFlushListener<Windowed<KIn>, VAgg>(context), this.sendOldValues);
        }
    }

    protected void maybeForwardUpdate(Record<KIn, VIn> record, Window window, VAgg oldAgg, VAgg newAgg, long newTimestamp) {
        if (this.emitStrategy.type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
            return;
        }
        this.tupleForwarder.maybeForward(record.withKey(new Windowed<KIn>(record.key(), window)).withValue(new Change<VAgg>(newAgg, this.sendOldValues ? oldAgg : null)).withTimestamp(newTimestamp));
    }

    protected void maybeForwardFinalResult(Record<KIn, VIn> record, long windowCloseTime) {
        long emitRangeLowerBound;
        long emitRangeUpperBound;
        if (this.shouldEmitFinal(windowCloseTime) && (emitRangeUpperBound = this.emitRangeUpperBound(windowCloseTime)) >= 0L && this.shouldRangeFetch(emitRangeLowerBound = this.emitRangeLowerBound(windowCloseTime), emitRangeUpperBound)) {
            this.fetchAndEmit(record, windowCloseTime, emitRangeLowerBound, emitRangeUpperBound);
        }
    }

    protected void logSkippedRecordForExpiredWindow(Logger log, long timestamp, long windowExpire, String window) {
        if (this.context().recordMetadata().isPresent()) {
            RecordMetadata recordMetadata = this.context().recordMetadata().get();
            log.warn("Skipping record for expired window. topic=[{}] partition=[{}] offset=[{}] timestamp=[{}] window={} expiration=[{}] streamTime=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset(), timestamp, window, windowExpire, this.observedStreamTime});
        } else {
            log.warn("Skipping record for expired window. Topic, partition, and offset not known. timestamp=[{}] window={} expiration=[{}] streamTime=[{}]", new Object[]{timestamp, window, windowExpire, this.observedStreamTime});
        }
        this.droppedRecordsSensor.record();
    }

    protected void updateObservedStreamTime(long timestamp) {
        this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
    }

    private boolean shouldEmitFinal(long windowCloseTime) {
        if (this.emitStrategy.type() != EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
            return false;
        }
        long now = this.internalProcessorContext.currentSystemTimeMs();
        if (now < this.timeTracker.nextTimeToEmit) {
            return false;
        }
        this.timeTracker.nextTimeToEmit = now;
        this.timeTracker.advanceNextTimeToEmit();
        return this.lastEmitWindowCloseTime == -1L || this.lastEmitWindowCloseTime < windowCloseTime;
    }

    private void fetchAndEmit(Record<KIn, VIn> record, long windowCloseTime, long emitRangeLowerBound, long emitRangeUpperBound) {
        long startMs = this.time.milliseconds();
        try (KeyValueIterator windowToEmit = this.windowStore.fetchAll(emitRangeLowerBound, emitRangeUpperBound);){
            int emittedCount = 0;
            while (windowToEmit.hasNext()) {
                ++emittedCount;
                KeyValue kv = (KeyValue)windowToEmit.next();
                this.tupleForwarder.maybeForward(record.withKey((Windowed)kv.key).withValue(new Change<Object>(((ValueAndTimestamp)kv.value).value(), null)).withTimestamp(((ValueAndTimestamp)kv.value).timestamp()).withHeaders(record.headers()));
            }
            this.emittedRecordsSensor.record((double)emittedCount);
            this.emitFinalLatencySensor.record((double)(this.time.milliseconds() - startMs));
        }
        this.lastEmitWindowCloseTime = windowCloseTime;
        this.internalProcessorContext.addProcessorMetadataKeyValue(this.storeName, windowCloseTime);
    }

    protected abstract long emitRangeLowerBound(long var1);

    protected abstract long emitRangeUpperBound(long var1);

    protected abstract boolean shouldRangeFetch(long var1, long var3);
}

