/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;

public class KTableReduce<K, V>
implements KTableProcessorSupplier<K, V, K, V> {
    private final String storeName;
    private final StoreFactory storeFactory;
    private final Reducer<V> addReducer;
    private final Reducer<V> removeReducer;
    private boolean sendOldValues = false;

    KTableReduce(MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized, Reducer<V> addReducer, Reducer<V> removeReducer) {
        this.storeFactory = new KeyValueStoreMaterializer<K, V>(materialized);
        this.storeName = materialized.storeName();
        this.addReducer = addReducer;
        this.removeReducer = removeReducer;
    }

    @Override
    public boolean enableSendingOldValues(boolean forceMaterialization) {
        this.sendOldValues = true;
        return true;
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return Collections.singleton(new StoreFactory.FactoryWrappingStoreBuilder(this.storeFactory));
    }

    @Override
    public Processor<K, Change<V>, K, Change<V>> get() {
        return new KTableReduceProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return new KTableMaterializedValueGetterSupplier(this.storeName);
    }

    private class KTableReduceProcessor
    implements Processor<K, Change<V>, K, Change<V>> {
        private KeyValueStoreWrapper<K, V> store;
        private TimestampedTupleForwarder<K, V> tupleForwarder;

        private KTableReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext<K, Change<V>> context) {
            this.store = new KeyValueStoreWrapper(context, KTableReduce.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.store.store(), context, new TimestampedCacheFlushListener(context), KTableReduce.this.sendOldValues);
        }

        @Override
        public void process(Record<K, Change<V>> record) {
            Object newAgg;
            long newTimestamp;
            Object intermediateAgg;
            if (record.key() == null) {
                throw new StreamsException("Record key for KTable reduce operator with state " + KTableReduce.this.storeName + " should not be null.");
            }
            ValueAndTimestamp oldAggAndTimestamp = this.store.get(record.key());
            Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
            if (record.value().oldValue != null && oldAgg != null) {
                intermediateAgg = KTableReduce.this.removeReducer.apply(oldAgg, record.value().oldValue);
                newTimestamp = Math.max(record.timestamp(), oldAggAndTimestamp.timestamp());
            } else {
                intermediateAgg = oldAgg;
                newTimestamp = record.timestamp();
            }
            if (record.value().newValue != null) {
                if (intermediateAgg == null) {
                    newAgg = record.value().newValue;
                } else {
                    newAgg = KTableReduce.this.addReducer.apply(intermediateAgg, record.value().newValue);
                    newTimestamp = Math.max(record.timestamp(), oldAggAndTimestamp.timestamp());
                }
            } else {
                newAgg = intermediateAgg;
            }
            long putReturnCode = this.store.put(record.key(), newAgg, newTimestamp);
            if (putReturnCode != Long.MIN_VALUE) {
                this.tupleForwarder.maybeForward(record.withValue(new Change(newAgg, KTableReduce.this.sendOldValues ? oldAgg : null, putReturnCode == -1L)).withTimestamp(newTimestamp));
            }
        }
    }
}

