/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.ResultOrder;
import org.apache.kafka.streams.state.VersionedRecordIterator;

@InterfaceStability.Evolving
public final class MultiVersionedKeyQuery<K, V>
implements Query<VersionedRecordIterator<V>> {
    private final K key;
    private final Optional<Instant> fromTime;
    private final Optional<Instant> toTime;
    private final ResultOrder order;

    private MultiVersionedKeyQuery(K key, Optional<Instant> fromTime, Optional<Instant> toTime, ResultOrder order) {
        this.key = key;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.order = order;
    }

    public static <K, V> MultiVersionedKeyQuery<K, V> withKey(K key) {
        Objects.requireNonNull(key, "key cannot be null.");
        return new MultiVersionedKeyQuery<K, V>(key, Optional.empty(), Optional.empty(), ResultOrder.ANY);
    }

    public MultiVersionedKeyQuery<K, V> fromTime(Instant fromTime) {
        return new MultiVersionedKeyQuery<K, V>(this.key, Optional.ofNullable(fromTime), this.toTime, this.order);
    }

    public MultiVersionedKeyQuery<K, V> toTime(Instant toTime) {
        return new MultiVersionedKeyQuery<K, V>(this.key, this.fromTime, Optional.ofNullable(toTime), this.order);
    }

    public MultiVersionedKeyQuery<K, V> withDescendingTimestamps() {
        return new MultiVersionedKeyQuery<K, V>(this.key, this.fromTime, this.toTime, ResultOrder.DESCENDING);
    }

    public MultiVersionedKeyQuery<K, V> withAscendingTimestamps() {
        return new MultiVersionedKeyQuery<K, V>(this.key, this.fromTime, this.toTime, ResultOrder.ASCENDING);
    }

    public K key() {
        return this.key;
    }

    public Optional<Instant> fromTime() {
        return this.fromTime;
    }

    public Optional<Instant> toTime() {
        return this.toTime;
    }

    public ResultOrder resultOrder() {
        return this.order;
    }
}

