/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.audit.log4j.correlation;

import java.util.Map;
import java.util.UUID;
import org.apache.knox.gateway.audit.api.CorrelationContext;
import org.apache.logging.log4j.core.LogEvent;

public class Log4jCorrelationContext
implements CorrelationContext {
    private final String requestId;
    private final String parentRequestId;
    private final String rootRequestId;

    public static Log4jCorrelationContext of(LogEvent event) {
        if (event == null) {
            return null;
        }
        Map data = event.getContextData().toMap();
        return data.containsKey("correlation_context_requestId") ? new Log4jCorrelationContext((String)data.get("correlation_context_requestId"), (String)data.get("correlation_context_parentRequestId"), (String)data.get("correlation_context_rootRequestId")) : null;
    }

    public static Log4jCorrelationContext random() {
        return new Log4jCorrelationContext(UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString());
    }

    public Log4jCorrelationContext(String requestId, String parentRequestId, String rootRequestId) {
        this.requestId = requestId;
        this.parentRequestId = parentRequestId;
        this.rootRequestId = rootRequestId;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getParentRequestId() {
        return this.parentRequestId;
    }

    @Override
    public String getRootRequestId() {
        return this.rootRequestId;
    }

    public String toString() {
        return "[request_id=" + this.requestId + ", parent_request_id=" + this.parentRequestId + ", root_request_id=" + this.rootRequestId + "]";
    }
}

